#!/bin/bash

cat > /dev/null <<.

You must explicitly run "sh install.sh" to install MOOSE.

Do NOT use the install.conf file from the distribution if any.
DO write your own install.conf file.

If you use a floppy, put the right floppy into the drive before running
install.sh


This script isn't finished yet.
Use rdev to modify bytes&words.
.
#--------------------------- END OF COMMENTS ---------------------------------



#------------------------------ FUNCTIONS ------------------------------------

# Adjust the parameters in the bootable image $DEST from the arguments
make_params ()
{

  ### Test boot sector size & signature ###
  if [ ${BOOTRECSIZE} -gt 1 ] ; then
    abort 1 "Boot sector over 512 bytes !"
  fi
  if [ "x$(get_word $DEST 510)" != "xAA55" ] ; then
    abort 2 "Invalid boot sector signature."
  fi

  ### Test LOADER size ###
  # if [ $LOADERSIZE -gt 4 ] ; then
  #  echo "Loader too large. LILO loading mode impossible."
  #  if [ $LOADMODE = L ] ; then abort 3 'LOADMODE "L" impossible'; fi
  #fi

  ### Tell the LOADER what LOADMODE to use ###
  if [ $LOADMODE = L ] ; then
    echo 'LOADMODE "L" is autodetected.' \
	 'Defaulting to mode "C" on a 1.4M floppy'
    LOADMODE=C
  fi
  echo -n ${LOADMODE} | set_char ${DEST} 0x024


  ### Report loader & kernel size in boot record ###
  KSIZE=$[${APISIZE}+${KERNELSIZE}]
  APIOFS=$[1+${LOADERSIZE}]
  APIOFS_B=$[${APIOFS}*512]
  KSIZE_B=$[${KSIZE}*512]
  RES_SIZE=$[1+${LOADERSIZE}+${KSIZE}]

  set_word ${DEST} 0x00E ${RES_SIZE}		# reserved sectors
  set_word ${DEST} 0x025 ${APIOFS}		# where loading shall begin
  set_byte ${DEST} 0x02A ${LOADERSIZE}		# loader size for bootrec
  set_byte ${DEST} 0x1F1 ${LOADERSIZE}		# loader size for LILO
  set_word ${DEST} 0x1F4 $[${KSIZE_B} >> 4]	# system size in para / mode L
  set_word ${DEST} $[${APIOFS_B}+32] ${KSIZE_B}	# API+K size for loader
}

set_char ()
{
  # $1 is the destination file to modify.
  # $2 is the offset of the modification.
  # $3 is the length of the string if given
  # stdin is the character or string to copy.

  dd $(printf 'of=%s seek=%d obs=1 ibs=4096 conv=notrunc count=%d' \
		 $1 $2 ${3:-'0x7FFFFFF'}) 2>/dev/null
}

set_word ()
{
  # $1 is the destination file to modify.
  # $2 is the offset of the modification.
  # $3 is the word to copy.
  rdev -v -o $(printf '%d %s %d' $2 $1 $3)
}

set_byte ()
{
  printf '%02x' $3 | htob | set_char $1 $2 1
}

get_char ()
{
  get_string "$1" "$2" 1 "$3"
}

get_string ()
{
  if [ -z "$4" ] ; then
    dd $(printf 'if=%s ibs=1 skip=%d count=%d obs=4096' $1 $2 $3) 2>/dev/null
  else
    eval "${4}=$(get_string $1 $2 $3)"
  fi
}

get_byte ()
{
  if [ -z "$3" ] ; then
    # printf '%d' 0x`
     get_char $1 $2 | btoh -h
    #`
  else
    eval "${3}=$(get_byte $1 $2)"
  fi
}

get_word ()
{
  if [ -z "$3" ] ; then
    #printf '%d' "0x`
     (get_char $1 $[1+$2] ; get_char $1 $2) | btoh -h
    #`"
  else
    eval "${3}=$(get_word $1 $2)"
  fi
}

DD ()
{
  RES="${1}" ; shift
  dd bs=${BLOCKSIZE} conv=sync "$@" 2>${TMP}
  read a b < ${TMP}
  : a=$a b=$b
  if [ -n "${RES}" ] ; then
    eval ${RES}=$[${a}]
  fi
}

rmtmp ()
{
  /bin/rm -f -- $TMP "$@"
}

abort ()
{
  if [ -f "$DEST" ] ; then rmtmp "$DEST" ; else rmtmp ; fi
  a=$1
  shift
  echo "$@"
  exit $a
}

#-----------------------------------------------------------------------------
Tests ()
{
  dd if=/dev/zero of=zap count=1 bs=512 2>/dev/null
  echo 'Hello, World !' | set_char zap 40
  set_byte zap 80  97
  set_byte zap 81  0xFF
  set_word zap 120 -2
  set_word zap 160 44510	# DE AD
  set_word zap 162 61374	# BE EF
  set_word zap 510 0xAA55
  set_byte zap 513 0x88
  set_word zap 514 0xADDE
  set_word zap 516 0xEFBE
  btoh < zap
  get_word zap 510 ; echo
  get_char zap 80 ; echo
  get_byte zap 81 ; echo
  get_string zap 40 15
  rm -f zap
  exit 0
}

#Tests

#-----------------------------------------------------------------------------

RCFILE=install.conf
TMP=/tmp/tmp-moose.install.sh-$HOST-$$-

main () {
  trap abort EXIT TERM HUP
  case "${LOADMODE}" in
    C|L)	{
		 DD BOOTRECSIZE	< ${BOOTRECBIN}
	         DD LOADERSIZE	< ${LOADERBIN}
		 # adjust size for LILO loading: at least 2KB for loader !!!
		 if [ $LOADERSIZE -lt 4 ] ; then
		   dd if=/dev/zero bs=512 count=$[4-$LOADERSIZE] 2>/dev/null
		   LOADERSIZE=4
		 fi
		 DD APISIZE skip=8 < ${APIBIN} # skip first (null) page.
		 DD KERNELSIZE	< ${KERNELBIN}
		} >${DEST}
		make_params
		;;
    D)		echo "Load mode Not supported yet"
		;;
    H)		echo "Load mode Not supported yet"
		;;
  esac
  DEST=	# install successful; don't erase image
}


#############################################################################
if [ -f ${RCFILE} ] ; then
  source ${RCFILE}
else
  abort 10 'You need to write your ${RCFILE} file prior to install.'
fi

if [ -z "$*" ] ;
then main
else
  case "$1" in
    /dev/*)
	DEST=${DESTBIN} main
        ( cat ${DESTBIN} ; dd bs=3k count=1 if=/dev/zero 2>/dev/null ) > "$1"
	exit 0
	;;
  esac
  "$@"
fi
