#ifndef DEBUGC_H
#define DEBUGC_H

#include <stdio.h>
#include <errno.h>

#ifdef DBGLVL
#  ifndef DEBUG
#    define DEBUG 1
#  endif
#else
#  ifdef DEBUG
#    define DBGLVL 100
#  else
#    define DBGLVL 0
#  endif
#endif


#define __COMMENT(LVL,lvl,file,xxx...)  ( ((LVL)>=(lvl))?fprintf(file,xxx):0 )
#define VERBOSE(lvl,xxx...)	   __COMMENT(VERBOSELVL,lvl,stdout,xxx)

#define __TRY(x,bad)	(((x)==(bad))?exit(errno):0)
#define TRY0(x)		__TRY(x,0)
#define TRYM1(x)	__TRY(x,-1L)


#if defined(DEBUG) && (!(DEBUG-1))	/* defined and not zero ! */
#  define DBGMSG(lvl,xxx...)	   __COMMENT(DBGLVL,lvl,stderr,xxx)
#else
#  define DBGMSG(lvl,xxx...)
#endif


#endif	/* DebugC.h */
