#ifndef GExceptn_H
#define GExceptn_H

#include "MyTypes.h"

#ifdef GExceptn_G
  #define vextern
#else
  #define vextern extern
#endif

/***** Generic Exception (and error) Module ****/
/**
   For use with an exception list.
   The file "mexceptn.sh" is a shell script using awk to produce exception
 C files from an exception metafile.
**/

/*** now, include the list of exception identifiers ***/
/**
  The format is a list of enumerates.
**/

typedef enum {
  EverythingOK,
  #include "exceptn.h"
} exnid ;

/******************************* TYPES ***********************************/

typedef FunPtr1 (void,void*,exnid) ExceptionHandler ;

typedef struct {
   char         * name ;
   char         * full_description ;
   ExceptionHandler   Handler ;
} ExnDescriptor ;


/***************************** CONSTANTS *********************************/

vextern void Raise ( exnid Exn ) ;
vextern void Trap ( exnid Exn, ExceptionHandler trap ) ;
vextern exnid CatchProc ( Procedure proc ) ;
extern  ExnDescriptor ExceptionDescr [] ;

extern const ExceptionHandler _DefaultHandler ;
vextern void AbortOnError(void*,exnid) ;

/***************************** VARIABLES *********************************/


/****************************** MACROS ***********************************/

#define ExceptionNumber(exn)	(exn)
#define ExceptionMessage(exn)	(ExceptionDescr[ExceptionNumber(exn)].name)
#define DefaultHandler		{ AbortOnError, NULL }

#define ENABLECATCHb(x)          TCatchBuf catchbuf##x
#define CATCHb(x)
#define WITHTRAPb(x)
#define ENDCATCHb(x)

#define CATCH                   CATCH(new())
#define WITHTRAP                WITHTRAP(_global)
#define ENDCATCH                ENDCATCH(_global)

#undef vextern
#endif /* gerror.h */
