#ifndef GIO_H
#define GIO_H

#include "MyTypes.h"

#ifdef GIO_G
  #define vextern
#else
  #define vextern extern
#endif

/**** OSL preprocessing
about this file:
   Header for "GIO" generic input/output module

about its implementation:
****/

/***************************** Objects Types *******************************/

typedef FUNPTR ( Char, void*, (void*) )                TReadFun ;
typedef FUNPTR ( void, void*, (void*,Char) )           TWriteFun ;
typedef FUNPTR ( long, void*, (void*,long,int) )       TSeekFun ;

typedef struct VIOstream {
  /* int IsInput:1 , IsOutput:1 , CanGoBackOnce:1 , CanSeek:1 ; */
  /* pas la peine: comparer read, write, ... sont a NULL si non existant */
 /** elementary operations **/
  Procedure Next ;		/* */
  Procedure Previous ;
  TReadFun  Current ;
  TWriteFun SetCurrent ;
 /** common macros **/
  TReadFun  Read ;		/* */
  TWriteFun Write ;
  TSeekFun  Seek ;		/* */
  Procedure Flush ;
  Procedure Close ;
  Procedure PutBack ;
  Procedure GetBack ;
  Procedure
} VIOstream ;

typedef VIOstream O_Input ;
typedef VIOstream O_Output ;

/*********************** Global data (beurk: that's C) *********************/

#undef vextern
#endif /* EOF GIO.h */
