#ifndef GList_H
#define GList_H

#include "MyTypes.h"

#ifdef GList_G
  #define vextern
#else
  #define vextern extern
#endif

/*OSL preprocessing
about this file:
   Header for "GList" generic list processing module

about its implementation:
   We'll use chained lists with the dreaded malloc().
****/

/***************************************************************************/

#define NAMEDTLIST(x,n)     struct n { x current ; struct n * next ; }
#define TLIST(x)            NAMEDTLIST(x,listof_##x)
#define TYPEDEF_LIST(x,l)   typedef NAMEDTLIST(x,l) l [1]
#define FOR_IN_LIST(e,l)    for ((e)=(l);(e)!=NULL;(e)=(e)->next)

#define NAMEDTRLIST(x,n)     struct n { x value ; struct n * previous ; }
#define TRLIST(x)            NAMEDTRLIST(x,rlistof_##x)
#define TYPEDEF_RLIST(x,l)   typedef NAMEDTRLIST(x,l) l [1]
#define FOR_IN_RLIST(e,l)    for ((e)=(l);(e)!=NULL;(e)=(e)->previous)

#define NAMEDTDLIST(x,n)     struct n { x value ; struct n * next ; \
                                        struct n * previous ; }
#define TDLIST(x)            NAMEDTRLIST(x,dlistof_##x)
#define TYPEDEF_DLIST(x,l)   typedef NAMEDTRLIST(x,l) l [1]


/*************************** memory allocation *****************************/

#define NEW(n)      ( (n) = malloc(sizeof(*n)) )
/** (!) You need malloc (in stdlib.h, for example) to do that **/

/*************************** Object descriptors ****************************/

#undef vextern
#endif /* GList.h */
