/*** Meta Tokenizer ***/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/****
  Creates a C file from a Meta C file.

input format is

...
#BEGIN TOKENIZE
Define xxx=yyy
...
Identifier: fields list ;
...
#END TOKENIZE
...


output is a list of token names and an array of fields associated to
each name.

Definable words are: trs

NAME		DEFAULT
ArrayHeader	"{"
ArrayFooter 	"}"
FieldSeparator	","
ArraySeparator	";"
TokInfoBegin    "{"
TokInfoEnd	"}"


Features to add:
- being able to replicate info from token name into fields
- more generally, being able to manage fields arbitrarily in input
as well as output.
- options so that default words be defined for Pascal, OSL, etc

NOTE: Awk would have been good if there weren't two list to produce, with
      exceptions for the last field and NOT the last line
      (i.e. not the same separator)
      or perhaps two awk programs ?
****/


char * HEADER = "\
/*\n\
  This file was automatically generated\n\
  by the Meta Error-ifier module (metaerr.c) from file %s\n\
  for use with the Generic Error Module (gerror.[hc])\n\
\*/\n\
\n\
" ;


void error (void)
{
  printf ("IO Error !") ;
  exit (1) ;
}



int Process (FILE *I,FILE *O)
/* returns non zero result iff something was successfully processed */
{
  int FoundMarker = 0 ;
  char LineBuffer [4096] ;
  int NumErr = 0 ;

  /** (1) Find Marker **/
  while (!feof(I))
  {
    fgets (LineBuffer,sizeof(LineBuffer),I) ;
    /* ... */
  }
  /* if (!FoundMarker) return 0 ; */
  /** (2) Process **/
  while (!feof(I))
  {
    fgets (LineBuffer,sizeof(LineBuffer),I) ;
    /* ... */
  }
  return FoundMarker ;
}




void main (int argc, char **argv)
{
  char *InputFileName = "error.mc", *OutputFileName = "error.c" ;
  FILE *I,*O ;

  if (argc>=1) InputFileName  = argv[1] ;
  if (argc>=2) OutputFileName = argv[2] ;

  I=fopen (InputFileName,"rt") ;
  O=fopen (OutputFileName,"wt") ;

  if ( I==NULL || O==NULL ) error () ;

  while ( Process (I,O) );
}  
  
