#ifndef THREAD_H
#define THREAD_H

#include "GList.h"
#include "GExceptn.h"

/********** include file for multiple threads in a program *************/

/**
  neither DOS nor Linux offer multithreading, so I assume here that no
  multithreading library was used. If some was, you must replace this
  file by the good one.
**/

/******************** Context: debugging info *********************/

#ifdef MY_DEBUG_INFO

TYPEDEF_RLIST (char *,TContext) ;

extern const TContext basic_context =
		{ (TContext*) &basic_context, "basic context" } ;

extern TContext *global_context = (TContext*) &basic_context ;

#define OpenProcedure(name)  \
   TContext context ; \
   context.previous=global_context ; \
   context.current=name ;
   global_context=&context

#define CloseProcedure() \
   global_context=context.previous

#else

typedef TContext ;
#define OpenProcedure(name)
#define CloseProcedure()

#endif /* MY_DEBUG_INFO */

/******************* thread-local data for exceptions **********************/

TYPEDEF_RLIST ( ExceptionHandler, TExnHndlrList) ;

extern TExnHndlrList Global_ExnHndlrList ;

#endif /* Thread.h */
