#ifndef STDCLADS_H
#define STDCLADS_H

#include "GObjects.h"

/** Standard objects in the Clad implementation.
**
*/

/* Prefixes:
 * cC_ class
 * cA_ atom
 * cS_ structure
 * cF_ global/total function/attribute
 * cf_ local/partial function/attribute
 */

/*** Booleans ***/
const Clad cC_Boolean, cA_Yes, cA_No ;	/* Class boolean and its two members */

/*** Classes ***/
const Clad cC_Class ;			/* The Class class */
const Clad cF_ClassOf ;			/* -> Clad's class */
const Clad cF_Q_IsMemberOf ;		/* -> -> if a clad is member */
const Clad cF_Q_OperatesOn ;		/* -> -> if can operate on clad */

/*** Names ***/
const Clad cF_ObjectNamed ;		/* name -> object, given context */
const Clad cF_NameOf ;			/* object -> name, given context */

/*** System objects ***/
const Clad cC_Raw ;			/* Raw (sequence of bytes) object */
const Clad cF_RawRepresentation ;	/* -> Raw representation of Clad */
const Clad cF_MakeClad ;		/* Makes a Clad from Raw (root only) */
const Clad cC_DynamicMemory ;		/* Allocatable memory object */

/*** Execution ***/
const Clad cC_Context ;			/* Execution Context */
Clad * pcX_State ;			/* Current machine state */
const Clad cC_Executable ;		/* Executable object class */
const Clad cf_Call ;			/* call with current continuation */
const Clad cf_JumpTo ;			/* execute code with implicit cont. */
const Clad cC_ML_Exec ;			/* machine language routine */

#endif /* stdclads.h */
