; /* MOOSE ``Magic'' number definition file. Works both in TASM and in C !!! */


; /*  TASM Code first

MAGIC_GOOSE		=	2099BDE7h
; Obtained this way:
; little endian	P	E	S	O	O	G
;       00	10000	01001	10011	01111	01111	00111
; 5 bit code for 'GOOSE' big-endian,
; 5 bit code for P (portable)
; two clear bits.

MAGIC_GOOSE_64		=	6099BDE7h
; Obtained this way:
; little-endian	P	E	S	O	O	G
;       01	10000	01001	10011	01111	01111	00111
; 5 bit code for 'GOOSE' little-endian,
; 5 bit code for P (portable)
; clear bit & set bit.
; This 32 bit value is followed (or preceded on big endian systems)
; by '64b!' or '128b'

MAGIC_PtbOSL		=	64DF1690h
; Obtained this way:
; little-endian	L	S	O	b	t	P
;       	01100	10011	01111	100010	110100	10000
; Portable OSL


MAGIC_OSLi386		=	1824B26Fh
; Obtained this way:
; little-endian	386	i	L	S	O
;       00  0110000010	01001	01100	10011	01111
; 5 bit code for 'OSL' little-endian,
; 5 bit code for i, 10-bit code for 386
; two clear bits.

MAGIC_LxAPI		=	01001001010000000001111000001100b
; little endian	+-	I	P	A	x	L
;		01	001001	010000	000001	111000	001100
; 6 bit code for 'LxAPI--' little-endian

MAGIC_PC_API		=	5300FC70h
				;01010011000000001111110001110000b
; little endian	+-	I	P	A	-	C	P
;		01	01001	10000	00001	11111	00011	10000
; 5 bit code for 'LxAPI--' little-endian


MAGIC_MARKER		=	0EFBEADDEh	; bytes: DEADBEEF


Struc Signature_Struc
  Magic_Number		dd	?
  Object_Name		db	20 dup (?)
  Version		db	8 dup (?)
EndS  Signature_Struc


; now, C
if 0
; */

#define MAGIC_GOOSE		0x2099BDE7
#define MAGIC_PtbOSL		0x64DF1690
#define MAGIC_OSLi386		0x1824B26F
#define MAGIC_LxAPI		0xC9401E0C
#define MAGIC_PC_API		0xD300FC70

#define MAGIC_MARKER		0xEFBEADDE	/* bswap'ed DEADBEEF */


; /* THEN Magic file Format (please cut and paste)

## Here is for little endian machines
## how is it with byte order ? I mean, I assumed little endian (386 like)
## was used here; else, all longs must be byte-reordered... :(

0	long		0x2099BDE7	GOOSE file, little endian
0	long		0xE7BD9920	GOOSE file, big endian
0	long		0x64DF1690	Portable OSL code, little endian
0	long		0x9016DF64	Portable OSL code, big endian
0	long		0x1824B26F	i386 OSL code
0	long		0x49401E0C	Linux API for MOOSE
0	long		0x5300FC70	PC API for MOOSE



## Here is for big endian machines
## how is it with byte order ? I mean, I assumed little endian (386 like)
## was used here; else, all longs must be byte-reordered... :(

0	long		0x2099BDE7	GOOSE file, big endian
0	long		0xE7BD9920	GOOSE file, little endian
0	long		0x64DF1690	Portable OSL code, big endian
0	long		0x9016DF64	Portable OSL code, little endian
0	long		0x6FB22418	i386 OSL code
0	long		0x0C1E4049	Linux API for MOOSE
0	long		0x70FC5300	PC API for MOOSE

endif
; */
