; APIHeader.asm
; Generic sources for MOOSE i386 APIs.
Ideal
Include "API.ash"

;;;;;;;;;;;;;;;;;;;;;;; Import External variables ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Extrn	__INIT__: ABS
Extrn	API_Entry_Point: NEAR

;;;;;;;;;;;;;;;;;;;;;;;;;;; Define Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
APISIZE = 0		; exact value set by external installer

;;;;;;;;;;;;;;;;;;;;;;; Define the generic header ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Segment HeaderBinary
;; The first 32 bytes are reserved for the signature
;; The first 20 bytes may be searched for to find the API.
;; The 12 remaining bytes may be used for version identification.
  Org PAGESIZE	; page 0 is skipped
   MagicNumber		dd	API_MAGIC
				; must have been defined after including
				; ../../M_Magic.h
  Org API_Offset+4
   Signature		db	API_NAME,0
  Org API_Offset+28
   version_major	db	VERSION_MAJOR
   version_minor	db	VERSION_MINOR
   version_patchlevel	db	VERSION_PATCH_LEVEL
   version_internal	db	VERSION_INTERNAL
;; After the signature, system fields
  Org API_Offset+32
	label	API_Header_S	API_Header_Struc
			dd	APISIZE
			dd	API_Entry_Point
			dd	API_Offset
			dd	__INIT__
			dd	4 dup (?)
EndS	HeaderBinary
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
End
