Include "../API.inc"
Include "M_Magic.h"

;;;;;;;;;;;;;;;;;;;;;;;; Version identification ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
API_MAGIC		=	MAGIC_PC_API
API_NAME		equ	"OSLm i386 BIOS API"
VERSION_MAJOR		=	0
VERSION_MINOR		=	0
VERSION_PATCH_LEVEL	=	0
VERSION_INTERNAL	=	2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Constants ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
API_Seg		=	0000h		; Where the API is originally loaded
API_Offset	=	PAGESIZE	; The corresponding offset in PM.
IRQ_INT_BASE	=	90h		; IRQ's are mapped at INT 90h
IDT_SIZE	=	100h		; Is that enough ?
PM_STACK_SIZE	=	400h		; 1024 entries

;;;;;;;;;;;;;;;;;;;;;;;;; Standard PM Selectors ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Name			sel.	base lim.	description
NULLSEG		=	0000h	;0	0	invalid null segment
TEMPSEG		=	0008h	;?	?	temporary
ALLMEMCS	=	0010h	;0	4G	all memory (code)
ALLMEMDS	=	0018h	;0	4G	all memory (data)
RMPARTCS	=	0020h	;?	?	RM Part of the API (code)
RMPARTDS	=	0028h	;?	?	RM Part of the API (data)
PMPARTCS	=	0030h	;?	?	PM Part of the API (code)
PMPARTDS	=	0038h	;?	?	PM Part of the API (data)
KL0CS		=	0040h	;1G	4G	Kernel PL0 Code Segment
KL0DS		=	0048h	;1G	4G	Kernel PL0 Data Segment
KL1CS		=	0051h	;1G	4G	Kernel PL1 Code Segment
KL1DS		=	0059h	;1G	4G	Kernel PL1 Data Segment
KL2CS		=	0062h	;1G	4G	Kernel PL2 Code Segment
KL2DS		=	006Ah	;1G	4G	Kernel PL2 Data Segment
KL3CS		=	0073h	;1G	4G	Kernel PL3 Code Segment
KL3DS		=	007Bh	;1G	4G	Kernel PL3 Data Segment
KL0CG		=	0080h	;?	?	Kernel PL0 Call Gate
KL1CG		=	0089h	;?	?	Kernel PL1 Call Gate
KL2CG		=	0092h	;?	?	Kernel PL2 Call Gate
KL3CG		=	009Bh	;?	?	Kernel PL3 Call Gate
KTSS		=	00A0h	;?	?	Kernel TSS

GDT_SIZE	=	0020h	;		Is that enough ?
