/*** Loader for the OSLm Kernel Header file ***/
#ifndef OSLmK_LOADER_H
#define OSLmK_LOADER_H

#include <sys/types.h>
#include <sys/ipc.h>

/*** Main functions ***/
caddr_t	Load_OSLm_object (FILE* Object_file, caddr_t MinMem, caddr_t MaxMem) ;
int	Exec_Loaded_OSLm_object	(caddr_t Object) ;
int	Exec_OSLm_object (FILE* Object_file, caddr_t MinMem, caddr_t MaxMem) ;

/*** Error module ***/
enum LoaderError_Code {
	LE_NO_ERROR,
	LE_WRONG_NUM_ARGS,
	LE_KEY_NOT_FOUND,
	LE_INVALID_OPTIONS,
	LE_OUT_OF_MEM,
	LE_API_NOT_FOUND,
	LE_KERNEL_NOT_FOUND,
	LE_FS_NOT_FOUND,
	Number_of_LE_codes
} ;
volatile void LoaderError(enum LoaderError_Code code,char*message) ;

#endif /* Loader.h */
