char * KernelBase ;
long * AllocedSize ;

/*-----------------*
 * Local Variables *
 *-----------------*/
static char * AllocedMem ;

/*------------------*
 * Useful functions *
 *------------------*/
extern void LoaderError(enum LoaderError_Code code,char*message) {
  printf ((code?"Loader error:%s\nAborting.":"%s\n"),message) ;
  exit (code) ;
}

static int GetMaxAvailableContinuousMem (void) {
  return mstats.bytes_free ;
}

static int LoadSignedFile ( FILE * F, int testlength,
			    char * buffer, int bufsize,
			    char * signature, int siglength,
			    int (*Length) (char*) )
/* testlength: length to load to decide if the file is good.
 * Length: returns the length of the file from the a pointer to the test zone.
 */
/* returns size of loaded file if successful,
 * length of the file is successful
 * -1 if signature not found, or wrong size (<testlength).
 * -2 if not enough mem.
 * -3 if IO error.
 */
{
	int size,cmp ;
	if (bufsize<testlength) return -2 ;
	size = fread ( buffer,1,testlength,F ) ;
	cmp = memcmp (signature,buffer,siglength) ;
	if (cmp) return -1 ;
	size = (*Length) (buffer) ;
	if (size<testlength) return -1 ;
	if (size>bufsize) return -2 ;
	cmp = fread ( buffer,1,size-testlength,F ) ;
	if (cmp+testlength!=size) return -3 ;
	return size ;
}


/* 		    enum LoaderError_Code LEC, char* ErrMessage ) */


/*----------------*
 * Main Functions *
 *----------------*/
static void Get_The_Mem (int MemAlign, int MinMem, int MaxMem) {

 /* In a next version, we should optimize memory consumption and
 |* allow parametrable allocation unit (for use with something else than
 |* malloc).
 \*/

  int MAX,t ;

  MAX = GetMaxAvailableContinuousMem () - MemAlign + 1 ;
  if (MAX<MinMem) goto  GTFM_Not_Enough_Memory ;
  if (MAX<MaxMem) AllocedSize=MAX ; else AllocedSize=MaxMem ;
  AllocedMem = malloc ( AllocedSize + MemAlign - 1 ) ;
  if (AllocedMem == NULL) goto GTFM_Not_Enough_Memory ;
  t = ((int) AllocedMem) + MemAlign-1 ;
  t -= t % MemAlign ;
  KernelBase = (char *) t ;

 GTFM_Not_Enough_Memory:
  LoaderError(LE_NOT_ENOUGH_MEM,"Not enough memory") ;
}

static int Load_The_API (FILE * API) {
 /* returns size of the file.
  */
  int size = LoadSignedFile ( API, 40,
			      KernelBase, AllocedSize,
			      "
			    char * signature, int siglength,
			    int (*Length) (char*) )

}

static void Load_The_Kernel () {
}

int Load_OSLm_Kernel (FILE * API_file, FILE * Kernel_file,
		      int MemAlign, int MinMem, int MaxMem) {
  Get_The_Mem (MemAlign,MinMem,MaxMem) ;
  Load_The_API (API_file) ;
  Init_System_Interface (Kernel_file) ;
  Jump_Into_The_API () ;
  free (AllocedMem) ;
}
