.xlist
if 0 ; (preliminary notes)

------------------------------------------------------------------------------
;									     ;
;			       OSLm i386 Kernel				     ;
;									     ;
------------------------------------------------------------------------------

Done:		Nothing.
Being done:	Everything.
To Do:		Everything.

------------------------------------------------------------------------------

Specifications:
A) Goals:
B) Constraints:
  Can be loaded anywhere. Only page boundary is assumed.

------------------------------------------------------------------------------

Loading Procedure:
  To load the Kernel, you must first have the API active and initialized
in memory, then, load the header somewhere in memory (see KHeader segment
group), take it into account, load the actual kernel (see OSLmKernel segment
group), initialize kernel global data (See GlobKData segment) and jump into
the kernel entry point (see KInitCode segment).

------------------------------------------------------------------------------

KHeader segment group:
* HeaderBinary segment:
   It contains data about exports of kernel code.
   It begins by a 32 byte signature identifying the kernel and its version.
   After that, it contains data about sizes of the kernel file components.
   Then, it contains .

* HeaderStrings segment:
   It contains the ascii names of objects exported by the kernel.

------------------------------------------------------------------------------

OSLmKernel segment group:
* KernelCode segment:
* GlobKData segment:
* KInitCode segment:

------------------------------------------------------------------------------


------------------------------------------------------------------------------

endif




;-----------------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;;; COMPILATION DIRECTIVES ;;;;;;;;;;;;;;;;;;;;;;;;;;;

IDEAL	; TASM Ideal mode (masm=#$*!@%, as any microsoft product)
;;; Listinf directives
%noctls
%noincl
%noconds
;;%nocref
masm
.xall
ideal
;%syms
;%notrunc
%list	; let's go

P386	; of course ! (allow protected mode)


;-----------------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;; Macros and Headers Include ;;;;;;;;;;;;;;;;;;;;;;;;

Include "../../Macro.INC"	; Macros
Include "../KMacros.inc"	; Kernel specific macros
Include "../../../M_Magic.h"	; Magic numbers

;-----------------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;; Define segments groups ;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Masm	;; Ensure that segments will be ordered in their appearing order
.SEQ	;
Ideal	;

Group	KHeader		HeaderBinary, HeaderStrings
Group   OSLmKernel	KernelCode, GlobKData, KInitCode
Assume	cs:OSLmKernel,ds:OSLmKernel,es:OSLmKernel,ss:OSLmKernel
Assume  fs:OSLmKernel,gs:OSLmKernel

;-----------------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Define segments ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Segment HeaderBinary	para public use32 'Kernel'
EndS
Segment HeaderStrings	byte  public use32 'Kernel'
EndS
Segment KernelCode	para  public use32 'Kernel'
EndS
Segment GlobKData	dword public use32 'Kernel'
EndS
Segment KInitCode	byte  public use32 'Kernel'
EndS

;-----------------------------------------------------------------------------
%Incl

Include "GKData.asm"	; Global Kernel Data
Include "KCode.asm"	; Kernel code
Include "KInit.asm"	; Kernel initialization
Include "KHeader.asm"	; Read header last, for it uses values of pointers in
			; the remaining of the code. But the header will
			; hopefully be first in the binary :-)

;-----------------------------------------------------------------------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; Public data ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Public definitions should allow (with a public map file)
; external programs to get the entry points rights.
;
public	KInitJumpPoint, TotalKernelFileLength
public	BeginningOfGKData, KernelOffset

;-----------------------------------------------------------------------------
End
