#include <stdio.h>
#include <linux/sched.h>

#define DBGLVL 1
#include "../../CLibs/DebugC.h"

#define myBSIZE 0x100
#define sigOFS  0x80
#define TSS (*((struct tss_struct *)BUFFER))
typedef int (*RelocProc) (void*where,...) ;

extern int _a_ ;
int _a_ = 1 ;

typedef struct str_T T ;
struct str_T { int x; int y ;};



int main (int argc, char**argv) {
  FILE * F ;
  unsigned char BUFFER [ myBSIZE*2 ] ;
  int r ;

  DBGMSG(1,"Opening file...\n") ;
  TRY0 ( F = fopen ("ctest.bin","rb") );

  DBGMSG(1,"Reading .BIN file ...\n") ;
  fread (BUFFER,myBSIZE,2,F) ;

  DBGMSG(1,"Found signature 0x%8lX ...\n", (*((long*)(BUFFER+sigOFS))) );

  DBGMSG(1,"Calling ASM routine ...") ;
  r = (  *  ( (int(*)(void*)) (BUFFER+myBSIZE) )  ) (BUFFER) ;
  DBGMSG(1," Call succeeded, returned 0x%X !\n",r) ;

  printf ( "Program Status:\n" ) ;
  printf ( "CS:EIP\t[%04X]:[%08lX]\t\t",TSS.cs,TSS.eip ) ;
  printf ( "EFlags: [%08lX]\n",TSS.eflags ) ;
  printf ( "SS:ESP\t[%04X]:[%08lX]\t\t",TSS.ss,TSS.esp ) ;
  printf ( "EBP:\t[%08lX]\t%11ld\n",TSS.ebp,TSS.ebp ) ;
  printf ( "DS:ESI\t[%04X]:[%08lX]  %11ld\t\t",TSS.ds,TSS.esi,TSS.esi ) ;
  printf ( "FS: [%04X]\n",TSS.fs ) ;
  printf ( "ES:ESI\t[%04X]:[%08lX]  %11ld\t\t",TSS.es,TSS.edi,TSS.edi ) ;
  printf ( "GS: [%04X]\n",TSS.gs ) ;

  printf ( "EAX:\t[%08lX]\t%11ld\t",TSS.eax,TSS.eax ) ;
  printf ( "EBX:\t[%08lX]\t%11ld\n",TSS.ebx,TSS.ebx ) ;
  printf ( "ECX:\t[%08lX]\t%11ld\t",TSS.ecx,TSS.ecx ) ;
  printf ( "EDX:\t[%08lX]\t%11ld\n",TSS.edx,TSS.edx ) ;

  return 0 ;
  exit (0) ;
}
