#ifndef _ARCH_H
#define _ARCH_H


/******************** ARCHITECTURE DEPENDENT DEFINES *************************/


/******************************** i386 ***************************************/
#ifdef i386

#define LONG_BITS	32
#undef _FLOAT_64

#define READ_LONG(A)		(* ((long*)(A)) )
#define DEF_VAL(L)		DEF_TEN_VAL(L)
#define NET_LONG(L)		long_swap_bytes(L)
#define MAKE_NET_LONG(L)	long_swap_bytes(L)

#ifdef __GNUC__
#define word_swap_bytes(w) \
	({ unsigned short n = (unsigned short) w ; \
	   (n << 8) | (n >> 8) ; \
	})
#define long_swap_bytes(L) \
	({ long n = L ; \
	   (long)word_swap_bytes(n>>16) | ((long)word_swap_bytes(n)<<16) ; \
	})
#else
unsigned short	word_swap_bytes (unsigned short L) ;
long		long_swap_bytes (long L) ;
#endif

#endif /* i386 */


/******************************* SPARC ***************************************/
#ifdef sun4

#define LONG_BITS	32
#undef _FLOAT_64

#define NET_LONG(L)		(L)
#define MAKE_NET_LONG(L)	(L)
#define DEF_VAL(L)		DEF_NET_VAL(L)

#ifdef __GNUC__
#  define READ_LONG(A)		\
	({ char * p = A ; \
	     (*p++ << 24) \
	   + (*p++ << 16) \
	   + (*p++ << 8) \
	   + (*p++ << 0) \
	})

#else
long	READ_LONG (char* A) ; /* unaligned */

#endif /* GNUC */

#endif /* sun4 */


#define DEF_NET_VAL(L)	\
	(char)(L>>24), \
	(char)(L>>16), \
	(char)(L>>8), \
	(char)(L)
#define DEF_TEN_VAL(L)	\
	(char)(L), \
	(char)(L>>8), \
	(char)(L>>16), \
	(char)(L>>24)

#endif /* arch.h */
