#define _PROCESS_0
#include <unistd.h>
#include "includes.h"
#include "system.h"
#include "runmain.h"
#include "forker.h"


/*
/ Data
*/

pid_t pcore_pids [ pcore_NUM_PROCESSES ] ; /* Process id's */
pcore_process_t current_process ;	  /* Which process this is */

volatile void (*(do_pcore_job [pcore_NUM_PROCESSES])) (void) = {
  NULL,		/* Process 0 needs not be launched: that's me, stupid ! */
  do_system,	/* Process 1 is system I/O process */
  do_runloop	/* Process 2 is the runtime process */
/* ,  do_timer */
};


/*
/ Fun's
*/

volatile void pcore_do_fork (void)
{
  pcore_process_t c ;				/* current process */
  pid_t p ;					/* result of fork () */

  current_process = c = p_init ;		/* first process (I/O) */
  pcore_pids [c] = getpid () ;
  pcore_pids [1] = getpid () ;

  for (c=pcore_NUM_PROCESSES-1;c>1;c--) {
    switch ( p=fork () )
      {
      case 0  /* child */  :	current_process = c ;
				pcore_pids [c] = getpid () ;
				(*do_pcore_job[c]) () ;
				___ (0,"Child exited !\n") ;
				abort () ;
				/* break ; */
      case -1 /* error */  :	___ (0,"Could not fork !\n") ;
				abort () ;
				/* break ; */
      default /* parent */ :	pcore_pids [c] = p ;
      }
  }

 ___(100,"Hack: launch process 1 appart !\n") ;
  current_process = c = 1 ;
  pcore_pids [c] = getpid () ;
  (do_pcore_job[c]) ();
}
