#ifndef _FORKER_H
#define _FORKER_H

/*
/ Header for the module that forks the main processes in the pcore package
*/



/*
/ Types
*/

typedef enum {
  p_init,	/* The initialization process */
  p_sys,	/* The first (unforked) process does all the I/O */
  p_run,	/* The second (forked) process does the computing */
/*  p_time,	/ * The third (forked) process signals the second regularly */
  pcore_NUM_PROCESSES
} pcore_process_t ;



/*
/ Data
*/

/* used only by the father I/O process: */

extern pid_t pcore_pids [ pcore_NUM_PROCESSES ] ; /* Process id's */
extern pcore_process_t current_process ;	  /* Which process this is */
extern volatile void (*(do_pcore_job [pcore_NUM_PROCESSES])) (void) ;


/*
/ Functions
*/

volatile void pcore_do_fork (void) ;	/* Do the actual forking */



#endif /* end of forker.h */
