/*
/ limits for the pcore implementation
*/


/******************** COMPUTING PROCESS *********************/

/* Number of bits used in longs */
#define MAX_LONG	((1<<(LONG_BITS-1))-1)

/* Limit for running process (malloc'ed) home-managed GC-able memory */
#define CORESIZE	0x1000000	/* 16 MB */
#define DEF_STACK_SIZE	16384		/* 16 KB must be enough */


/************************** IPC *****************************/
/*
/ We split the program into an I/O process for system calls, and a computing
/ process.
*/


/***** SHARED MEMORY *****/

/* Size of each buffer */
#define PCORE_BUFSIZE	0x2000		/* 8 KB */

/*
/  Total shared memory size:
/  We have to keep it small, as systems like Linux want shared memory segments
/ to be completely allocated in virtual memory. Thus, if we reserved a 1GB
/ address space for shm, the 1 GB would have been allocated in (main memory
/ and) swap space !!!
*/
#define SHM_SIZE	0x40000		/* 256 KB */

/* Size of a shared memory page */
#define SHM_PAGE_SIZE	SHMLBA
#define SHM_PAGE_MASK	(~(SHM_PAGE_SIZE-1))



/***** MESSAGES *****/

/*
/   Max size of messages as POSIX ensures 512 bytes can be sent atomically into
/ a pipe, this limit can allow us to simulate messages with a pipe used by
/ several event providers.
/   By default, we use SYSV IPC message passing facilities...
*/
#define MAX_MSG_SIZE	508
