#ifndef _LLOBJECTS_H
#define _LLOBJECTS_H

/*
/ llobjects.h
/   contains the definition of low-level classes and objects under
/ the pcore implementation of OSL.
/
*/

/************************* TYPDEF's *******************************/

#define CELLt		union pcore_cell
#define FUNt		pcore_fun
#define CONTEXTt	struct pcore_context
#define ASSOCt		struct pcore_association
#define ASSOC_LISTt	struct pcore_association_list
#define LAZYt		struct pcore_lazy_expression
#define IDENTIFIERt	struct pcore_identifier

typedef CELLt	FUNt		(CELLt x,...) ;



/*************** Low Level objects are made up of cells. ***********/
CELLt {
 /* terminal data view point */
  Int		all ;
  Char		raw[1] ;
  sInt		si ;
  uInt		ui ;
  Char		c ;
  sInt32	si32 ;
  uInt32	ui32 ;
  Real		r ;
  AnyPtr	ap ;
  Char *	cp ;
  sInt *	sip ;
  uInt *	uip ;
  CELLt *	Cp ;
  FUNt		fp ;
};


/********************* Associations & Contexts ******************************/

ASSOCt {
  CELLt	Attribute ;
  /* Beware: the lowest bits indicates if Value is
     the actual value
     a pointer to a standard function returning the value,
     a pointer to a context in which to look for the value,
  or a lazy construct returning the value
  */
  CELLt Value ;
} ;

/* An association list associates values to attributes */
ASSOC_LISTt {
  uInt		length ;
  ASSOCt	assoc [1] ;
} ;

CONTEXTt {
  CONTEXTt *	left ;	/* tree of association lists; useful for
			 * secure context managing (hiding part of the
			 * context, while adding another one).
			 */
  CONTEXTt *	right ;
  ASSOC_LISTt * assocs ;/* In the assoc list may or not be information about
			 * the balancing of the context subtree ...
			 */
};

ASSOCt * Find_Attrib (int depth,CONTEXTt * context,CELLt Attribute) ;

/*********************** Implementation of classes ***********************/
/*
 A Class is just a Context in which to find and/or or execute the so-called
 methods.
*/

Consider_


/************************ Lazy partial evaluation ************************/


/**************************** Saving objects *****************************/



/********************* object description structures *********************/



/**** Interface to a memory manager ****/
MEMCLASSt {
  pcore_fun *	size ;		/* get the size of the object */
  pcore_fun *	copy ;		/* copy the object's value */
  pcore_fun *	link ;		/* create a hard link on the object */
  pcore_fun *	unlink ;	/* destroy a hard link on the object */
  pcore_fun *	compare ;	/* compare the object to another */
};

ATTRIBUTEt {
  IDENTIFIERt *	name ;
  FUNt *	evaluator ;
};

IDENTIFIERt {
  NAMEt *	name ;
};

NAMEt {
  CharPtr	shortname ;		/* just the name */
};

#endif
