#ifndef _PCORE_MEMORY_H
#define _PCORE_MEMORY_H

#include "llobjects.h"

/*********************** Internal memory management **********************/

/* We do count links on objects */
CELLt * pcore_New_Object (uInt size) ;
void	pcore_Link_Object (CELLt * Object) ;
void	pcore_Unlink_Object (CELLt * Object) ;

/* Debugging functions */
uInt	pcore_Mem_Free (void) ;
uInt	pcore_LargerBlockFree (void) ;
uInt	pcore_Mem_size (void) ;
uInt	pcore_ask_more_mem (void) ;	/* ask more memory from the system */
void	pcore_Verify_Heap (void) ;
void	Reload_All (void) ;		/* Emergency procedure for general
					 * failure
					 */
void	Save_And_Reload_All (void) ;	/* Emergency procedure when memory
					 * has become like swiss cheese.
					 */

#endif /* _PCORE_MEMORY_H */
