#ifndef MINISL_H /* Mini Stack Language */
#define MINISL_H

#include "thread/types.h"
#include "arch.h"
#include "llobjects.h"

/********************************* TYPEDEFS *********************************/
typedef struct msl_instr_tbl_t {
  void (*code) (void) ;
  char * C_name ;
  char * FORTH_name ;
} msl_instr_tbl_t ;


typedef void	      (*msl_instr_t) (void) ;	/* threaded token code */

/* used for external code -> threaded code translation */


/************************** LIST OF INSTRUCTIONS ****************************/

enum minisl_intructions {
#include "minisl.ho1"
  NUM_OF_MSL_INSTR
};

/**************************** EXTERNS ****************************************/
extern msl_instr_t *	msl_pc ;
extern CELLt *		msl_sp ;
extern CELLt *		msl_rp ;

/************************ Defining functions *********************************/

CELLt minisl (msl_instr_t* _pc,
		   CELLt * _sp,CELLt * _spbot,CELLt * _sptop,
		   CELLt * _rp,CELLt * _rpbot,CELLt * _rptop) ;
void __CodeDump__ (FILE * file,msl_instr_t * dpc) ;


#include "minisl.ho2"

#endif	/* minisl.h */
