#!./build.sh meta_c

###############################################################################
######################### Minimal Stack language ##############################
###############################################################################

# This is a shell script using "./build.sh meta_c" to produce
#  a .c "C" program file, and
#  a .h "C" header  file.


########################### HERE, THE CODE ####################################
BEGIN_META_C

# Initialize some parameters for build.sh

	CODERET="void"
	CODEARGS="(void)"
	CODE=msl_
	ENUM=msli_




############################# DEFINITIONS #####################################

CO2 '/*
  Herein, TOP refers to the stop of the stack, NEXT to what is next to it.
  Stack is checked at each instruction. A further version will provide
  safe and unsafe versions for each instruction...

ASSUMED MACROS:
--------------
 INSTRUCTIONS (no check)
  push(v)		pushs given element on the stack; no check.
  pop()			returns element popped off the stack; no check.
  rpush(v)		pushs given element on the return stack; no check.
  rpop()		returns element popped off the return stack; no check.
  immediate()		returns an immediate value from the instruction list
  get_next_instr()	returns token for the next instruction
  next_instr()		prepares for the next instruction

 CHECKS
  check_sp_up (n)	checks there are enough (n) arguments
  check_sp_down (n)	checks there is enough stack space for n cells
  check_rp_up (n)	checks there are enough (n) return values
  check_rp_down (n)	checks there is enough return stack space for n cells
  check_pc (n)		checks that n instructions are available.
  check_w_Caddr(p)	checks cell address for write
  check_r_Caddr(p)	checks cell address for read
  check_w_caddr(p)	checks char address for write
  check_r_caddr(p)	checks char address for read

 LVALUES
  next			next element on stack
  top			element on top of stack
  pc			program counter
  sp			stack pointer
  ld			dynamic link register (environment)
  pcell(p)		cell pointed to by pointer p
  pchar(p)		char pointed to by pointer p

 VALUES
  INSTR_PER_CELL	number of instruction units per data cell.
  CHAR_PER_CELL		number of chars per data cell.
  MSL_TRUE		true flag (1 or -1) in MiniSL
  MSL_FALSE		true flag (0) in MiniSL
  MSL_FLAG(x)		returns FLAG corresponding to value x

TRAPS:
-----
  The is a table of available traps.
*/'


################### AND NOW, THE ACTUAL INSTRUCTIONS #######################


INSTR	VOID	"NOP"	"--" '
{
	next_instr() ;
}'

INSTR	TRAP	"TRAP"	"Traps to the core system" '
{
	check_sp_up (1) ;
	TRAP_Handler(pop().ap) () ;
	/* NO next_instr() ; */
}'


INSTR	IMM	"VAL"	"-- n" '
{
	check_sp_down (1) ;
	check_pc(INSTR_PER_CELL) ;
  ___(750,"IMM %08lX\n",pc[1]) ;
	push ( immediate() ) ;
	next_instr() ;
}'

INSTR	ADD	"+"	"next top -- top+next" '
{

	check_sp_up (2) ;

	next.si+=top.si ;
	pop() ;

/* DOES WORK.
	{CELLt sum ;
	sum.ui=(pop().ui+pop().ui) ;
	push(sum) ;}
*/

/* WHY DOESN'\''T _THAT_ WORK ???
	push(pop().ui+pop().ui) ;
*/

	next_instr() ;
}'

INSTR	SUB	"-"	"next top -- next-top" '
{
	check_sp_up (2) ;
	next.ui-=top.ui ;
	pop () ;
	next_instr() ;
/*
  more secure than
	push(-pop()+pop())
  which assumes left-to right evaluation of +,
  that can be false in another language this is adapted in,
  and where the adapter (human or machine) can be unaware of this feature.
*/

}'


INSTR	JMP	"PC!"	"new_pc --" '
{
	check_sp_up(1) ;
	pc = pop ().ap ;

	/* NO next_instr() ;*/
}'

INSTR	"PC"	"PC@"	"-- oldpc" '
{
	check_sp_down(1) ;
	push (pc) ;
	next_instr() ;
}'

INSTR	SETSP	"SP!"	"new_sp --" '
{
	check_sp_up(1) ;
	check_sp_up((top.Cp-sp)) ;
	check_sp_down((top.Cp-sp)) ;
	sp = top.ap ;
	next_instr() ;
}'

INSTR	"SP"	"SP@"	"-- old_sp" '
{
	check_sp_down(1) ;
	push (sp) ;
	next_instr() ;
}'

INSTR	SETLD	"LD!"	"new_ld --" '
{
	check_sp_up(1) ;
	ld = top.ap ;
	next_instr() ;
}'

INSTR	"LD"	"LD@"	"-- old_ld" '
{
	check_sp_down(1) ;
	push (ld) ;
	next_instr() ;
}'


INSTR	"BRZ"	"BRZ"	"newpc flag -- ; Branch if zero value" '
{
/* Definition:
    : BRZ IF DROP ELSE PC! THEN ; 
*/
	check_sp_up(2) ;
	if (pop().ui) 
		{ pop () ; next_instr () ;}
	else	{ pc=pop ().ap ;}
	next_instr() ;
}'

INSTR	"BRNZ"	"BRNZ"	"newpc flag -- Branch if non zero value" '
{
	check_sp_up(2) ;
	if (pop().ui) 
		{ pc=pop ().ap ; }
	else	{ pop () ; next_instr () ;}

  /* : BRNZ IF PC! ELSE DROP THEN ; */
	next_instr() ;
}'

: '
 CALL   PC@ >R PC!
 RET	R> PC!

 We must then define >R and R>, RP! and RP@
'

INSTR	"STO"	"!"	"val addr -- ;Store cell into memory" '
{
	check_sp_up(2) ;
	check_w_Caddr(top.Cp) ;
	pcell (top.Cp) = next ;
	pop () ;
	pop () ;
	next_instr() ;
}'

INSTR	"LOD"	"@"	"addr -- val ;Load cell from memory" '
{
	check_sp_up(1) ;
	check_r_Caddr(top.Cp) ;
	top = pcell (top.Cp) ;
	next_instr() ;
}'

INSTR	"CSTO"	"C!"	"val addr -- ;Store char into memory" '
{
	check_sp_up(2) ;
	check_w_caddr(top.cp) ;
	pchar (top.cp) = next.ui ;
	pop () ;
	pop () ;
	next_instr() ;
}'

INSTR	"CLOD"	"C@"	"addr -- val ;Load char from memory" '
{
	check_sp_up(2) ;
	check_r_caddr(top.cp) ;
	top.ui = pchar (top.cp) ;
	next_instr() ;
}'



INSTR	FLAG	"0<>"	"sets flag iff non-null value" '
{
	check_sp_up (1) ;
	top.ui = top.ui ? MSL_TRUE : MSL_FALSE ;
	next_instr() ;
}'

INSTR	NOT	"NOT"	"bitwise NOT of top of stack" '
{
	check_sp_up (1) ;
	top.si ^= -1 ;
	next_instr() ;
}'

INSTR	AND	"AND"	"pops TOP and NEXT, push the bitwise AND." '
{
	check_sp_up (2) ;
	push(pop().ui&pop().ui) ;
/* Isn'\''t that pretty ? */
	next_instr() ;
}'

INSTR	OR	"OR"	"pops TOP and NEXT, push the bitwise inclusive OR." '
{
	check_sp_up (2) ;
	push(pop().ui|pop().ui) ;
	next_instr() ;
}'

INSTR	XOR	"XOR"	"pops TOP and NEXT, push the bitwise exclusive OR." '
{
	check_sp_up (2) ;
	push(pop().ui^pop().ui) ;
	next_instr() ;
}'


INSTR	EQ	"="	"pops TOP & NEXT, push flag according to TOP NEXT =" '
{
	check_sp_up (2) ;
	push(MSL_FLAG(pop().ui==pop().ui)) ;
	next_instr() ;
}'

INSTR	NEQ	"<>"	"pops TOP & NEXT, push flag according to NEXT <> TOP" '
{
	check_sp_up (2) ;
	push(MSL_FLAG(pop().ui!=pop().ui)) ;
	next_instr() ;
}'

INSTR	LT	"<"	"pops TOP & NEXT, push flag according to NEXT < TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.si < top.si) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	GT	">"	"pops TOP & NEXT, push flag according to NEXT > TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.si > top.si) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	LE	"<="	"pops TOP & NEXT, push flag: NEXT <= TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.si <= top.si) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	GE	">="	"pops TOP & NEXT, push flag: NEXT >= TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.si >= top.si) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	ULT	"U<"	"pops TOP & NEXT, push flag according to NEXT < TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.ui < top.ui) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	UGT	"U>"	"pops TOP & NEXT, push flag according to NEXT > TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.ui > top.ui) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	ULE	"U<="	"pops TOP & NEXT, push flag: NEXT <= TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.ui <= top.ui) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	UGE	"U>="	"pops TOP & NEXT, push flag: NEXT >= TOP " '
{
	int flag ;

	check_sp_up (2) ;
	flag = MSL_FLAG(next.ui >= top.ui) ;
	pop () ;
	pop () ;
	push (flag) ;
	next_instr() ;
}'

INSTR	SHR	"SHR"	"shift TOP bits right once" '
{
	check_sp_up (1) ;
	top.ui >>= 1 ;
	next_instr() ;
}'

INSTR	SAR	"SAR"	"arithmetical shift TOP bits right once" '
{
	check_sp_up (1) ;
	top.si >>= 1 ;
	next_instr() ;
}'

INSTR	MUL	"*"	"TOP*NEXT replaces TOP and NEXT" '
{
	check_sp_up (2) ;
	push(pop().si*pop().si) ;
	next_instr() ;
}'

INSTR	DIVMOD	"/MOD"	"NEXT/TOP and NEXT mod TOP replace NEXT and TOP" '
{
	CELLt q,r ;

	check_sp_up (2) ;

	q.si = next.si / top.si ;
	r.si = next.si % top.si ;

	next = q ;
	top = r ;
	next_instr() ;
}'

INSTR	CELLS	"CELLS"	"multiply count to have an offset in CELLS" '
{
	check_sp_up (1) ;
	top.ui <<= 2 ;	/* (!) 4 chars per cell */
	next_instr() ;
}'

INSTR	DUP	"DUP"	"pushes TOP again" '
{
	check_sp_up (1) ;
	check_sp_down (1) ;
	push(top.ui) ;
	next_instr() ;
}'

INSTR	DROP	"DROP"	"pops TOP" '
{
	check_sp_up (1) ;
	pop() ;
	next_instr() ;
}'

INSTR	OVER	"OVER"	"pushes NEXT" '
{
	check_sp_up (2) ;
	push(next.ui) ;
	next_instr() ;
}'

INSTR	SWAP	"SWAP"	"swaps TOP and NEXT" '
{
	CELLt t ;

	check_sp_up (2) ;
	t = top ;
	top = next ;
	next = t ;
	next_instr() ;
}'

INSTR	PUSH	">R"	"pushes a value from main stack to return stack" '
{
	check_sp_up (1) ;
	check_rp_down (1) ;
	rpush(pop().ui) ;
}'

INSTR	POP	"R>"	"pops value from return stack to main stack" '
{
	check_rp_up (1) ;
	check_sp_down (1) ;
	push(rpop().ui) ;
}'

INSTR	StackDump	".S"	"dump stack contents" '
{
	_output_stack (stdout) ;
	next_instr() ;
}'

INSTR	CodeDump	".C"	"dump contents of the code to execute" '
{
	__CodeDump__(stdout,pc) ;
	next_instr() ;
}'

INSTR	End_Of_Dump	""	"marks the end of a code dump" '
{
	___(15,"Ya shadn'\''t execute such a End_Of_Dump marker !\n");
	next_instr() ;
}'


#Hi-level calls:
#CONTEXT		(the thread's context) (or LD ops ?)
#EVAL		(object, method)
#.
#IN
#OUT


######################### NOW, SOME USEFUL WORDS ############################




########################## FINALLY, THE FOOTER ##############################



################################ EOF ########################################

END_META_C

############################ UNPARSED REMARKS ################################


Instruction summary:

JMP	PC!
PC	PC@
SETSP	SP!
SP	SP@
BRZ
BRNZ
STO	!
LOD	@
NOT
AND
XOR
OR
EQ	=
NEQ	<>
LT	<
GT	>
LE	<=
GE	>=
ULT	U<
UGT	U>
ULE	U<=
UGE	U>=
ADD	+
SUB	-
SHR
SAR
MUL	*
DIVMOD	/MOD
DUP
DROP
OVER
SWAP
FLAG
StackDump .S



### La machine de P. Cousot:
Void
Stop
Add
Sub
Mult
Div
Ifless	<
Ifeq   	=
BrZero
PC@
PC!
SP@
SP!
LD@
LD!
@
!
Val #n
IMM
CODE	next:=code pointed at by top

DumpCode	jusqu' fin
DumpPile	du dbut  SP (pile croissante)
Fin
