#define _PROCESS_3
#include "includes.h"
#include "pcoreipc.h"		/* We use this stuff */
#include "runloop.h"		/* for globals of the runloop */
#include "timer.h"		/* some of our own stuff */

/*
/ All process (3) is here.

* wait for process (2) to be ready
* Initialize time.
* Wait for asked delay.
* Get current time.
* compute remaining time to wait before reaching next pulse
* if time negative (pulse already exceeded), tell the write how many pulses
 were skipped
* Send a SIGALRM signal to process (2)
* loop to waiting for asked delay.

Note:
* if process (2) does not want the timer anymore, it can block the signal, or
tell process (1) to kill -STOP/-CONT process (3); but then, a second mechanism
must be used so that process (2) asks process (1) what time it is.
*/


static void timer_sync (void) {		/* synchronize the timer process */
  /* Wait for the computing process to be ready
  / before we can send it signals ! */

  struct sembuf semops [1] = { 
    {sem_runloop_busy,0,0}
  };
  semop (pcore_sem_id,semops,1) ;
}

static void timer_exit (void) {
  struct sembuf semops [1] = { 
    {sem_timer_busy, -1,0}
  };
  semop (pcore_sem_id,semops,  1) ;
}

volatile void do_timer (void) {
  ___ (1,"Running...\n") ;
  timer_sync () ;
  ___ (1,"Exiting...\n") ;
  timer_exit () ;
  exit (0) ;
}
