#ifndef _PARSEOPTS_H
#define _PARSEOPTS_H

/**************** PARSE OPTS COMPILE-TIME PARAMETERS ***************/
/* actually, these are not currently supported, but should */


/* we may wanna find&parse a given config file before the other options
 (like dosemu) */
#undef FIRST_SCANNED_OPTION	


/* + switch for long named arguments */
#define ACCEPT_PLUS_LONG_ARGS	0


/* plus is a reverse switch */
#define PLUS_REVERSE_SWITCH	0


/* end at first non_option argument */
#define END_AT_NON_OPTION	0


/* include argument list in file after an @ for DOS arguments... */
#define INCLUDE_ON_@		0


/* if never see -ab as -a -b */
#define NO_CONSECUTIVE_OPTIONS	0



/*********************** PARSE OPTS STRUCTURE **********************/

typedef void (*po_action) (void*) ;

typedef struct po_option {
  char	    switchar;
  char*	    longname;
  po_action action;
  void*	    actionarg;
} po_option ;

/**** PARSE OPTS VARIABLES & SUBROUTINES FOR YOUR OPTION ACTIONS ***/

extern int	po_argc ;		/* main()'s argc argument */
extern char**	po_argv ;		/* main()'s argv argument */

extern int	po_arg_idx ;		/* current argument */
extern char*	po_arg_p ;		/* char in argument */
extern int	po_argument_forgotten ;	/* boolean: argument has (just) been */


void po_forget_argument (void) ;
void po_forget_argument_character (void) ;

void * po_SetNULL (void ** dest) ;
char * po_Parse_String_Arg (char ** dest) ;
void   Nop (void) ;


/*********************** PARSE OPTS MAIN CALL **********************/

void Parse_Options (int*  argc, char*  argv[],
		    po_option  options []) ;

/* beware:
 * it modifies argc and argv[], so that the caller can parse
  parameters that aint options ;
 * it leaves argv[][] unmodified (unless your actions do modify them),
  so your actions can rely on pointing to them for string constants.
*/

#endif /* parseopts.h */
