#ifndef _PCOREIPC_H
#define _PCOREIPC_H

#include <sys/ipc.h>	/* SYSV IPC */
#include <sys/shm.h>	/*  shared memory */
#include <sys/sem.h>	/*  semaphores */
#include <sys/msg.h>	/*  messages */

/*
/ pcoreipc.h	module to use SYSV InterProcess Communication.
/
/ Processes (1) <-> (2): messages, shm buffers, semaphores for sync.
/ Processes (2) <-> (3): current hour through shm, semaphore for sync.
/
*/

/****************************** IPC Keys ***********************************/

#define PCORE_IPC_KEY	((char)('p'+'c'+'o'+'r'+'e'))
#define PCORE_SHM_KEY	((char)(PCORE_IPC_KEY+'s'+'h'+'m'))
#define PCORE_SEM_KEY	((char)(PCORE_IPC_KEY+'s'+'e'+'m'))
#define PCORE_MSG_KEY	((char)(PCORE_IPC_KEY+'m'+'s'+'g'))



/******************************** Types ************************************/

enum semaphore_names {
  sem_runloop_busy,
  sem_timer_busy,
  PCORE_NSEMS
};



/******************** GLOBAL DATA IN SHARED MEMORY *************************/

struct globals_t {
 /* Synchronization flags */
  int runloop_ready:1 ;		/* only this one is used outside debugging */
  int io_ready:1 ;
  int timer_ready:1 ;
  int terminating:1 ;

  int ipc_test_flag ;

 /* runloop (2) -> (3) timer */
   ulong  udelay_meant ;	/* delay asked in useconds */

 /*   timer (3) -> (2) runloop */
   time_t current_time ;	/* last time reported by process (3) */
   ulong total_ticks ;		/* total number of ticks sent */
   ulong total_skipped_ticks ;	/* total number of ticks missed */

 /* system  (1) -> (2) runloop */

 /* runloop (2) -> (1) system */
   

};				/* global structure in shared memory */

#define SHM_G(x) ( ((struct globals_t*) shm_base) -> x )



/************************** Global data **************************/

extern int	pcore_shm_id ;		/* shm descriptor */
extern int	pcore_sem_id ;		/* sem descriptor */
extern int	pcore_msg_id ;		/* msg descriptor */

extern size_t	shm_size ;		/* size of shared memory */
extern char *	shm_base ;		/* base of shared memory mapping */



/************************* Fun's **************************/

void pcore_init_ipc (void) ;
void pcore_free_ipc (void) ;

#endif
