#define _PROCESS_2
#include "includes.h"
#include "pcoreipc.h"
#include "forker.h"
#include "runloop.h"
#include "runmain.h"
#include "schedule.h"
#include "threads.h"
#include "words.h"


/************************** polling for events **************************/
/*
 This thread will poll for external events (as signaled by process (1))
 It activates only when an event is found.
implementation choice:
1) SIGUSR1 reactivates it. NO
2) It works as a timed condition to poll for a flag in SHM_G. YES
Beware that the timed condition activates only if some thread has
asked I/O, so when all threads are idle, no I/O polling is done.
*/
static void Event_Poller (void) {
}


/************************** Initialization routines *********************/


static void Analyse_Options (void) {
 ___ (7,"Initializing objects for each command of the command line.\n") ;

/* look at each command line argument */
}


static void MainThread (void) {
 ___ (6,"That's the Main Thread talking to you !\n") ;

  Analyse_Options () ;

  Test_minisl () ;

  t_yield () ;
}


static void runloop_init (void) {
  /* setup the threads:
    - polling for events (as we can't use interrupts to switch threads).
     - for each event arrived, treat it.
     - keyboard may be treated as events...
    - a first thread to execute the configuration file if not asked to skip.
    - when finished, it goes on parsing the command line as a program
     with some special command-line context.
  */

  SHM_G(ipc_test_flag) = 1 ;

  Init_Threads (MainThread,NULL) ;



  Exit_Threads () ; /* When the thread package kills self */
}


static void runloop_sync (void) {       /* synchronize the computing process */
  struct sembuf semops [1] = { 
    {sem_runloop_busy,-1,0}
  };

___(11,"Free the semaphores.\n") ;
	semop (pcore_sem_id,semops,1) ;
}


/******************** Main initialization function *********************/

volatile void do_runloop (void) {
___(1,"Running as process %d\n",current_process) ;
	runloop_init () ;
	/*pcore_attach_shm () ;*/

___(1,"Exiting...\n") ;

	/* Send "kill" message to the other process */
	SHM_G(terminating)=1 ;
        SHM_G(ipc_test_flag) = -1 ;
	shm_base[10000] = -1 ;

___(100,"IPC test flags set to %d %d\n",
    SHM_G(ipc_test_flag),shm_base[10000]) ;
        runloop_sync () ;
	exit(0);
}
