#ifndef _SYSTEM_H
#define _SYSTEM_H

/*********************** TYPEDEF's ***************************/

typedef enum pcore_sys_job_type	pcs_job_type ;
typedef struct pcore_sys_job	pcs_job ;

/************************* STRUCTS ***************************/

enum pcore_sys_job_type {
  pcore_sys_input_job,
  pcore_sys_output_job,
  pcore_sys_exception_job
};

struct pcore_sys_job {
  int		id ;			/* job number */
  pcs_job_type	type ;			/* seems clear to me */
  int		fd ;			/* file descriptor */
  Char*		buffer ;		/* buffer to use in shm */
  Char*		size ;			/* size of job asked */
  AnyPtr	info ;			/* additional job dependent info */
  void	      (*do_io) (pcs_job* job) ;	/* to call when fd ready */
  void	      (*delete) (pcs_job* job) ;/* to call on a kill, to free info */
};

/*
 I didn't see the point of having a job rely on multiple file descriptors
being ready, as unix doesn't have any atomic multiple-file-descriptor
operation that I know of but select() itself.
*/

/*********************** I/O helping routines ***********************/

pcs_job *  pcs_Create_Job	(void) ;
void	   pcs_Delete_Job	(pcs_job * job) ;
void	   pcs_Register_Job	(pcs_job * job) ;
void	   pcs_UnRegister_Job	(pcs_job * job) ;

void	   pcs_Acknowledge	(int id,int code) ;



/*********** Initialization routine ************/

volatile void do_system (void) ;	/* only forker.c must use it ! */


#endif /* system.h */
