#ifndef _DEBUG
#define _DEBUG

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "types.h"
#include "standard.h"

/* This is the public header file and should be used by programmers
 * in their files.  Any functions not declared in here, as well as
 * any data structures in debug.c are OFF LIMITS!  Functions should
 * be accesed by their MEM_ equivalents to ensure that they disappear
 * when DEBUG is not defined.
 */

extern FILE *hFile;
typedef void *FakePtr;

/* This keeps track of whether the system has been bootstrapped yet */
extern Boolean fBootStrapped;


#ifdef MEM_DEBUG
#define D_Assert(expr, szError)  (expr) ? (void)0 : (void)_D_AssertFailed(__FILE__, __LINE__, szError)
#define D_AssertWhere(expr, szError, iLine, szFile)  (expr) ? (void)0 : (void)_D_AssertFailed(szFile, iLine, szError)
#define D_PrintStr(str) { fprintf(hFile, str); fflush(hFile); }
#define D_PrintStrInt(str, iInt) { fprintf(hFile, str, iInt); fflush(hFile); }
#define D_PrintStrLong(str, lLong) { fprintf(hFile, str, lLong); fflush(hFile); }

#define MEM_BootStrap()  if(fBootStrapped==FALSE) D_BootStrap()
#define MEM_Alloc(uSize) D_MemAlloc(uSize, __LINE__, __FILE__)
#define MEM_Free(vPtr)   D_MemFree(vPtr, __LINE__, __FILE__)
#define MEM_CheckPointer(vPtr)  D_MemCheckPointer(vPtr, __LINE__, __FILE__, 1)
#define MEM_Shrink(vPtr, iNewSize)  D_MemShrink(vPtr, iNewSize)
#define MEM_Grow(vPtr, iNewSize)  D_MemGrow(vPtr, iNewSize)
#define MEM_DumpUsage()  D_MemDumpUsage()
#define MEM_CheckAllPointers()  D_MemCheckAllPointers(__LINE__, __FILE__)
#define MEM_DumpPointers() D_MemDumpPointers()
#define MEM_TheEnd()  D_TheEnd()

#else
#define D_PrintStr(szString)          ;
#define D_PrintStrInt(szString, i)    ;
#define D_PrintStrLong(szString, l)   ;
#define D_Assert(expr, str)           ;
#define D_AssertWhere(expr, s, i, e)  ;
#define MEM_Alloc(uSize)              malloc(uSize)
#define MEM_Free(vPtr)                free(vPtr)
#define MEM_CheckPointer(vPtr)        ;
#define MEM_CheckAllPointers()        ;
#define MEM_DumpPointers()            ;
#define MEM_Shrink(vPtr, iNewSize)    realloc(vPtr, iNewSize)
#define MEM_Grow(vPtr, iNewSize)      realloc(vPtr, iNewSize)
#define MEM_DumpUsage()               ;
#define MEM_BootStrap()               ;
#define MEM_CheckAllPointers()        ;
#define MEM_DumpPointers()            ;
#define MEM_TheEnd()                  ;
#endif

/* Random assertion helpers */
void _D_AssertFailed(String strFile, UInt uiLine, String strError);

/* prototypes for debugging memory functions */
void *D_MemAlloc(size_t uSize, UInt uiLine, String strFile);
void  D_MemFree(FakePtr fakePtr, UInt uiLine, String strFile);
void *D_MemShrink(void *vPtr, size_t sizeNew);
void *D_MemGrow(void *vPtr, size_t sizeNew);
void  D_MemCheck(void);
void  D_MemDumpUsage(void);

/* Pointer Checker stuff */
void    D_MemCheckPointer(FakePtr fakePtr, UInt uiLine, String strFile, Boolean fDisp);
void    D_MemCheckAllPointers(UInt uiLine, String strFile);
void    D_MemDumpPointers(void);
size_t  D_MemGetBlockSize(FakePtr fakePtr);

/* Prototypes for hashing functions used */
void    D_MemHashNewEntry(UInt uiKey, size_t sizeBlock, UInt uiLine, String strFile);
void    D_MemInitHashTable(void);
Boolean D_MemKeyInTable(UInt uiKey);
UInt    D_MemHashFunc(UInt uiNumber);
void    D_MemDeleteEntry(UInt uiKey);

/* Misc prototypes */
void    D_BootStrap(void);
void    D_TheEnd(void);
char   *StringCopy(String str1, String str2, UShort usLength);

#endif
