#ifndef _QUEUE 
#define _QUEUE 
 
#include "standard.h"
#include "types.h" 
 
/* Data structure for Queue Object:  A linked list based implementation
 * has been used, for having a fairly low creation time, and (virtually)
 * limitless size.  The main cost of insertion and deletion is allocating
 * and freeing up memory, so a twist on the conventional linked list
 * based queue has been taken.  When an Object is taken off of the
 * queue, the memory it used (its QNode) is not freed, and only the ptrTail
 * is modified.  The next time an insertion is done, it is virtually free,
 * because the memory has already been allocated and the link is already
 * done, and also, the remove is cheap, since it involves no free.  In this
 * way, I believe I have implemented a high-performance, arbitrary sized
 * queue module, that is the best of both worlds (linked list and array
 * implementations).
 */


typedef struct _QNode
{
 any_ptr         pvObject;
 struct _QNode  *next;
} QNode;


typedef struct _Queue
{
  QNode  *ptrHead;
  QNode  *ptrTail;
} *Queue, *PQueue;    /* I prefer Hungarian, so I alias it for my own use */

typedef any_ptr JFun_t (any_ptr state, any_ptr pvObject) ;

/* API for the Queue object (see queue.c for descriptions) */
Queue    q_create(void);
void     q_destroy(PQueue pQueue);
void     q_insert(PQueue pQueue, any_ptr pvObject);
void     q_cut_in_line(PQueue pQueue, any_ptr pvObject);
any_ptr  q_remove(PQueue pQueue);
Boolean  q_is_empty(PQueue pQueue);
any_ptr  q_head(PQueue pQueue);

/* I (Fare') added this one: */
any_ptr  q_journey(PQueue pQueue,JFun_t JFun,any_ptr state);

/* for debugging purpose: */
void     q_print(PQueue pQueue);
UInt	 q_size(PQueue pQueue);
UInt	 q_realsize(PQueue pQueue);

#endif
