#ifndef P2_STANDARD_H
#define P2_STANDARD_H

/* The includes that project 2 might depend on */
#include <stdio.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#ifndef P1_STANDARD_H
#define P1_STANDARD_H

#ifndef P0_STANDARD_H
#define P0_STANDARD_H
/* Define any_ptr to be a void pointer. In this way we can cast
 * any kind of pointer to/from any_ptr. (ANSI C only.)
 */
typedef void *any_ptr;

#endif /* P0_STANDARD_H */

/* A void function. */
typedef void (*ThreadFunc)();

#endif /* P1_STANDARD_H */

typedef enum {PRIORITY_HIGH, PRIORITY_LOW} Priority;

enum {T_OK=0,T_ERROR=-1,T_HARD_RT_FAIL=-2};

typedef struct {
  int registered;               /* time of registration */
  int signaled;                 /* time thread was signaled */
  int interval;                 /* condition timer interval */
  int  iterations;              /* how many times signaled */
} RT_Timing_Info;

#endif /* P2_STANDARD_H */
