#ifndef _TYPES
#define _TYPES

#include "../types.h"

/* The idea here is that we define certain types that are guarenteed
 * to be identical across platforms and architectures.  Also, a few
 * extra types, such as String, are defined for clarity:
 *
 *      Int:     32 bit integer
 *      UInt:    32 unsigned integer
 *      Short:   16 bit integer
 *      UShort:  16 bit unsigned integer
 *      Float:   single precision floating point
 *      Double:  double precision floating point
 *      Byte:    one byte, unsigned
 *      Char:    a character
 *      String:  a pointer to an array of characters
 *
 * [Fare: I modified that to use "../types.h"; Char was made unsigned]
 */

typedef uInt32	UInt;
typedef sInt16	Short;
typedef uInt16	UShort;
typedef Real32	Float;
typedef Real64	Double;
typedef Char	Byte;
typedef Char*	String;

#endif
