#ifndef _PCORE_TYPES
#define _PCORE_TYPES
 
/*
 * We define types
  {u,s}Int{8,16,32,64}
  for unsigned/signed integers with 8,16,32 and 64 bits.
  Real{32,64} for 32/64 bit floating point reals.
 * There may be more bits, but the size ratios must match, and only
  the given precision will be used.
 * Actually, PCORE will depend upon Makefile configuration:
  _USE_64   is defined iff PCORE will use 64 bit cells.
 * "C" type sizes are given by:
  _SHORT_32 is defined
  _FLOAT_64 is defined iff type float is 64 bits (and not 32).
 * You must change it if it fails for your system.
 * sInt,uInt and Real are 32 or 64 bit according to _USE_64.
 * Int is same as sInt.
*/ 


typedef	unsigned char		uInt8 ;
typedef	 signed  char		sInt8 ;
typedef	unsigned char		Char ;

#ifndef _SHORT_32
typedef	unsigned short		uInt16 ;
typedef	 signed  short		sInt16 ;
typedef	unsigned long		uInt32 ;
typedef	 signed  long		sInt32 ;
#ifdef __GNUC__
typedef	unsigned long long	uInt64 ;
typedef	 signed  long long	sInt64 ;
#endif
#else
typedef	unsigned short		uInt32 ;
typedef	 signed  short		sInt32 ;
typedef	unsigned long		uInt64 ;
typedef	 signed  long		sInt64 ;
#ifdef __GNUC__
typedef	unsigned short short	uInt16 ;
typedef	 signed  short short	sInt16 ;
#endif
#endif

#ifndef _FLOAT_64
typedef float			Real32 ;
typedef double			Real64 ;
#else
typedef float			Real64 ;
#endif

#ifndef _USE_64
typedef sInt32			sInt ;
typedef uInt32			uInt ;
typedef sInt32			Int ;
typedef Real32			Real ;
#else
typedef sInt64			sInt ;
typedef uInt64			uInt ;
typedef sInt64			Int ;
typedef Real64			Real ;
#endif

typedef void *			AnyPtr ;
typedef Char *			CharPtr ;
typedef Int *			IntPtr ;

/* Define Boolean type, and associated constants. */
typedef enum { TRUE,FALSE } Boolean;


#endif /* _PCORE_TYPES */
