#!./build.sh meta_c

###############################################################################
####################### WORDS DEFINED FOR THE MINISL ##########################
###############################################################################

# This is a shell script using "./build.sh meta_c" to produce
#  a .c "C" program file, and
#  a .h "C" header  file.


###############################################################################









########################### HERE, THE CODE ####################################
BEGIN_META_C

# Initialize some parameters for build.sh

	CODERET="void"
	CODEARGS="(void)"
	CODE=msl_
	ENUM=msli_


THREADED_CODE msl_test_code <<-'END'

///////// A BASH-BASED MINI-STACK-LANGUAGE ASSEMBLER, YES, SIR ! ////////
/ slashes '/' begin comments,
/ not backslashes 'cause they mix up the shell quoting !

/// a Sample macro to exit
: exit
/ evaluate arguments first, in case it contains the answer
  $*
  0
  JMP
;


/ call function in a mono-stack machine with LD
/ $* is the function to call; it must be a two-cell IMM statement
/ 
/ leave space for result, which means result is of determistic size
/ for compilation course, simulate a multistack machine, by reserving
/ machine state at fix address, then use stack as space for dynamic
/ object allocation.
/ 
/
/: acall
/  !localdef 2
/  $*
/  JMP
/  !!$(local 1):
/:
/;

: enter / $1: number of parameters, $2: number of locals
   LD
   SP
   DUP
   SETLD
   $2
   CELLS
   SUB
   SETSP
;

: leave
;


/// Let's begin with a debugging statement ///
/ : null is a useful statement to comment out something...
	CodeDump

	#MSL_Start_up
	DUP
	JMP

MSL_Start_up:
	
	StackDump
	0xFA5E
	DROP

	StackDump
	$exit 0x1EA4BABE	/ Yeah, babe !

/ an "End_Of_Dump" is automatically put by build.sh
END


END_META_C


: '
JMP		ok
TRAP		ok
IMM		ok
PC		ok
SP		ok
SETSP
LD		ok
SETLD
BRZ
BRNZ
STO
LOD
NOT
AND
XOR
OR
EQ
NEQ
LT
GT
LE
GE
ULT
UGT
ULE
UGE
ADD		ok
SUB		ok
SHR
SAR
MUL
DIVMOD
DUP
DROP
OVER		ok
SWAP
FLAG
StackDump	ok
CodeDump	ok
End_Of_Dump	ok
'
