Module __Matrices__ (* a "natural language" module *)

 given a semi-ring A,
 given index sets I and J
  Define the set of (_mname_: matrices(singular:matrix) ) as
   the linear space of the functions from I*J to 
  The set of such matrices is written
    #[ format(curled M indiced_by { I,J } (A)) ].

  given an index set K
   Define the composition of matrices as an infix multiplicative operator 
    from
     #[ format(curled "M" indiced_by { I,J } (A)) ] *
      #[ format(curled "M" indiced_by { J,K } (A)) ]
    to
      #[ format(curled "M" indiced_by { I,K } (A)) ]
    as
    for any P,Q and indices i,j
      (PQ) [i,j] = Sum (for all k in K) (P[i,k] * P[k,j]).

  if A is a unitary ring of unit 1, and null element 0,
    then an identity matrix is a matrix I such that
      I[i,j] = kronecker_symbol(i,j)
       where kronecker_symbol(i,j) is 1 iff i=j, else is 0,
        and is written #[ format(curled delta indiced_by { i,j } ) ].


  note (or admit) that composition of matrices has the following properties:
    it is associative
    composing on either side by some given matrix is a linear function
    multiplying by a scalar is equivalent to composing on either side
     by a proper identity matrix multiplied by the same scalar if possible.

  typical names for constant matrices are A,B,C,...
  typical names for variable matrices are M,N,P,...


Comments on "natural language" modules:

  This module assumes that basic algebraic modules already have been opened,
together with corresponding syntactic modules (e.g. for "multiplying on
either side").
  It also assumes basic natural language modules have been opened to use
typical names, etc.
