; Tests / exemples
; ===========================================================================

(define target 'as86)

(define (increment reg)
  (case target
    ('as86 (inst 'add reg 1))
    (else (error unsupported-target))))

(define (decrement reg)
  (case target
    ('as86 (inst 'sub reg 1))
    (else (error unsupported-target))))

; Here is an exemple. It shows what can be done. Don't try to analyse
; what the program does. Also the indexing shown may not be possible.
(define program
  (seq
   (inst 'mov ax bx)
   (inst 'add ax 4)
   (inst 'jmp (label 'hello))
   (comment "Now something a bit more complex.")
   (inst 'mov ax (index bp bx 10))
   (label 'j23)
   (inst 'mov (r16 al) (index bp bx -6))
   (inst 'mov ecx (index (scale ebp 4) ebx 10))
   (increment ax)
   (seq (inst 'mov ax bx)
	(increment cx))
   (inst 'jmp (label 'j23))
   ))

(newline)
;(display-asm program 'as86)
;(compile program 'as86 "output.s")

; Here's the output (inside the stars)
;****************************************************************************
;*; Assembler file generated by the Scheme Tunes LLL generator
;*
;*	mov	AX, BX
;*	add	AX, 4
;*	jmp	hello
;*; Now something a bit more complex.
;*	mov	AX, [BP+BX+10]
;*j23:
;*	mov	AX, [BP+BX-6]
;*	mov	ECX, [EBP*4+EBX+10]
;*	add	AX, 1
;*	mov	AX, BX
;*	add	CX, 1
;*	jmp	j23
;***************************************************************************



; An exemple program with control structures
(define prog2
  (seq
   (if-jump ax '> bx (label 'j23))
   (if-jump ecx 's<= edx (label 'j24)) ; The s before the <= is for "signed"
   (if-jump cx '= 0 (gen-label))
   (if-jump ecx '= 0 (gen-label))
   (while cx '> 0 (seq (decrement cx) (increment dx)))
   (comment "The same while but this time with a break when dx = 45")
   (comment "The other label in while-labels is the continue point")
   (let ((end-of-while (gen-label)))
     (while-labels cx '> 0 (seq (decrement cx) 
				(increment dx)
				(if-jump dx '= 45 end-of-while))
		   (gen-label) end-of-while))
   (comment "Here's an if-then-else")
   (if-then-else cx '= 0 
		 (comment "The then part would be here.")
		 (comment "The else part would be here."))))

;(display-asm prog2 'as86)
;(compile prog2 'as86 "output2.s")

; Here's the output (inside the stars)
;****************************************************************************
;*; Assembler file generated by the Scheme Tunes LLL generator
;*
;*	cmp	AX, BX
;*	ja	j23
;*	cmp	ECX, EDX
;*	jle	j24
;*	cmp	CX, 0
;*	je	l7
;*	cmp	ECX, 0
;*	je	l6
;*l5:
;*	sub	CX, 1
;*	add	DX, 1
;*	cmp	CX, 0
;*	ja	l5
;*l4:
;*; The same while but this time with a break when dx = 45
;*; The other label in while-labels is the continue point
;*l3:
;*	sub	CX, 1
;*	add	DX, 1
;*	cmp	DX, 45
;*	je	l2
;*	cmp	CX, 0
;*	ja	l3
;*l2:
;*; Here's an if-then-else
;*	cmp	CX, 0
;*	jne	l1
;*; The then part would be here.
;*	jmp	l0
;*l1:
;*; The else part would be here.
;*l0:
;****************************************************************************


(define prog3
  (struc 'point 
	 (elem 'x byte)
	 (struc 'point2 
		(elem 'x byte)
		(elem 'y long)
		(elem 'color word 3)
		(elem 'name long 64))
  	 (elem 'color word 3)
	 (elem 'name long 64)))

;(display-asm prog3 'as86)
;(compile prog3 'as86 "output3.s")

; Here's the output (inside the stars)
;***************************************************************************
;*; Assembler file generated by the Scheme Tunes LLL generator
;*
;*point_x = 0
;*point_point2_x = 1
;*point_point2_y = 4
;*point_point2_color = 8
;*point_point2_name = 16
;*point_color = 272
;*point_name = 280
;***************************************************************************