; Initialization of the TUNES i386 BIOS API
; ===========================================================================

; Lots of info taken from the sources of the Linux console driver.


(set! p-mode #f)

(add-code! 
 'codeseg
 (seq (entry (label 'api_entry_point))
      (label 'api_entry_point)

; Called by the boot loader.
;Input:
; the whole API must be loaded at linear address APIOFS (0x00001000)
; cs,ds,es,ss must be zero
; [System_Length]: the total length of the system file loaded at APIOFS
; [COMMAND_LINE]: a zero-terminated ascii string (command line arguments)
;			of max length 2047 not to overwrite the API
; sp=COMMAND_LINE-14  (!)Beware, stack is less than 768 bytes deep
; dword [sp+10]: Total Extended Memory
; dword [sp+6]: Total Conventional Memory
; dword [sp+2]: Available Conventional Memory
; word [sp]: CPU type
;Output:
; Never exits,
; but launches TUNES instead.

; Init Console
      ; Define Video Mode: text mode 80x25, 16 colors, clear screen @ 0xB8000
      (inst 'mov ax #x0003)
      (inst 'int #x10)
      
      ; Print Init Message
      (pr "Initializing TUNES:\r\n")
      
      ; Set the keyboard repeat rate to the max
      (mov ax #x0305)
      (clr bx)
      (inst 'int #x16)

; Get parameters from the LOADER
      ; Get CPU type
      (inst 'pop (op-size word (index (label 'cputype))))
      (if debug1 (pr "CPU:       0x"
		     (list 'word (index (label 'cputype)))
		     "\r\n")
	  (seq))

      ; Get available conventional memory
      (inst 'pop eax)	; optimize for below
      (mov (index (label 'AvConvMem)) eax)
      (if debug1 (pr "AvConvMem: 0x" 
		     (list 'dword (index (label 'AvConvMem)))
		     "\r\n")
	  (seq))
      
      ; Get total conventional memory
      (inst 'pop (op-size dword (index (label 'ConvMem))))
      (if debug1 (pr "ConvMem:   0x" 
		     (list 'dword (index (label 'ConvMem)))
		     "\r\n")
	  (seq))

      ; Get available/total extended memory
      (inst 'pop (op-size dword (index (label 'XtdMem))))
      (if debug1 (pr "XtdMem:    0x" 
		     (list 'dword (index (label 'XtdMem)))
		     "\r\n")
	  (seq))

      ; Get command line
      ; (nothing to do: loader put it at COMMAND_LINE, zero-ended)
      (if debug1 (pr "Command line is:\r\n"
		     (list 'asciiz COMMAND_LINE)
		     "\r\n")
	  (seq))


; Initialize some PM Part variables
      ; save real-mode IDT
      (inst 'sidt (index (label 'RM_IDT_address)))
      (if debug1 (pr "IDT: "
		     (list 'wzone ds RM_IDT_address 3)
		     "\r\n")
	  (seq))
      
      ; Putting the RM Part seg everywhere has been done below !
      
      ; ain't that all ?
      ;.....


; Move the Real-Mode Part to where it belongs

      ; Compute the target location for RM Part.
      ;mov eax,[AvConvMem]	; (!) optimized above
      ;zdwoz({"AvConvMem: 0x"},[AvConvMem],{CRLF}) ; let's check it
      (inst 'shr eax 4)
      (inst 'sub ax #x1000)	; 64 KB in para

      ; Firstly, Initialize some variables with it
      (mov (index (label 'RM_Part_seg)) ax)
                              ; tell the PM part where to find the RM part !
      (mov (index (label 'RM_Target_seg)) ax)
                              ; target when back into RM...
      (mov (index (label 'Actual_INT_Interceptor_seg)) ax)
                              ; RM->PM interrupt interceptor
      (if debug1 (pr "RM_Part_seg: "
		     (list 'word ax)
		     "\r\n")
	  (seq))

      ; Then, Do move
      (if debug1 (pr "Moving the Real-Mode Part to where it belongs... ")
	  (seq))
      (mov si (name 'rmpart_actbeg))
      (mov es ax)
      (mov di (rmaddr (name 'rmpart_actbeg)))
      (mov cx (binop "/" (binop "+" (name 'rmpart_actlen) 1) 2))
      (if debug1 (pr "\r\nSource: " (list 'addr ds si)
		     " Dest:" (list 'addr es di)
		     " Count: 0x" (list 'word cx) 
		     "\r\n")
	  (seq))

      (inst 'cld)
      (inst 'rep)
      (inst 'movsw)

      ; Clear the zone containing uninitialized RM part data
      ; So we can be confident that data defined up there is properly zeroed
      (if debug1 (pr "Clearing the RM BSS... ") (seq))
      (clr ax)
      (mov cx (binop "/" (binop "+" (name 'rmpart_bsslen) 1) 2))
      (if debug1 (pr "\r\nDest: " (list 'addr es di)
		     " Count: 0x" (list 'word cx)
		     ; "cs:ip=" (list 'addr cs ip)
		     "\r\n"))
      (inst 'rep)
      (inst 'stosw)

      (if debug2
	  (seq (ppmov fs #xB800)
	       (inst 'seg fs)
	       (mov (index 0) (op-size dword #x07450744))
	       (pushing (list ds es)
			(ppmov ds 0)
			(ppmov es ds)
			(if debug1 (pr "Done.\r\n") (seq))
			(inst 'seg fs)
			(mov (index 4) (op-size dword #0x07550742)))))

; Jump up in (initialization portion of) moved RM Part of the API ...
      ; use stack and data in rmpart
      (ppmov ds es)
      (ppmov ss ds)
      (mov esp (rmaddr (name 'RMPartStackTop)))
      (ppmov es 0)
      (if debug2 (seq (inst 'seg fs)
		      (mov (index 8) (op-size dword #x07200747)))
	  (seq))

      ; jump in RM Part...
      (STOP fs 0 6 0 (char->integer #\M) #x07)
      (if debug1 (pr "Jumping up... "))
      (STOP fs 0 7 0 (char->integer #\E) #x07)
      (pushm (rmaddr (label 'UpThere)) ds)
      (inst 'retf)))


(add-code! 
 'codeseg
 (seq (label 'UpThere)
      (STOP es 0 9 0 (char->integer #\P) #x07)
      ; Initialization routine in moved RM part
      ;Input:
      ; The RM part has been moved up
      ; offset of data is rmaddr(original_offset).
      ; cs,ds,ss,es=RMPART,RMPART,RMPART,0
      ; esp=rmaddr(RMPartStackTop)
      ;Output:
      ; Now, we shall go in protected mode as soon as possible:
      ; everything is *so* much easier from there,
      ; and we write all support routines for PM anyway,
      ; so why not use them or write crippled redundant
      ; real-mode counterparts ?

      (if debug1 (pr "Here I am up in RM part !\r\n") (seq))

; Initialize RM Part variables
      ; compute RM and PM values for cr0
      (mov eax cr0)
      (mov (index (rmaddr (name 'RM_cr0))) eax)
      (inst 'and eax (not32 (bitwise-or CR0_PG CR0_CD CR0_NW CR0_AM CR0_WP)))
      (inst 'or al CR0_PE)
      (mov (index (rmaddr (name 'RM_cr0))) eax)

; Disable all interrupts
      (inst 'cli)
      (if debug1 (pr "Disabling IRQs\r\n") (seq))
      (call 'RM_Mask_IRQs)
      (if debug1 (pr "Disabling NMI\r\n") (seq))
      (call 'RM_Disable_NMI)
      (if debug1 (pr "All interrupts disabled\r\n") (seq))
      
; Jump into the Protected Mode
      (if debug1 (pr "Let's jump into protected mode !\r\n") (seq))
      (inst 'br (label 'GoProtect))

; Here, hack,hack,hack: a frame for Return_From_R86 (see pmpart.m4)
;  Well, after all, because and the space wasted by unneeded registers
; in the frame, and a special case added to the server, paging enabler,
; or R86 returner this will be much longer than it is. And to be efficient,
; we wouldn't even remove the code-modifying we're doing.
; We wouldn't gain anything at wasting time doing that. Let's not.
      ))


; ---------------------------------------------------------------------------
; API PM Entry Point
; ---------------------------------------------------------------------------

(set! p-mode #t)

(define (PrGDT)
  (showl "GDTlim0 GDTbase GDT...")
  (inst 'sub esp (- (* 17 2 4) 2))
  (inst 'sgdt (index esp))
  (inst 'push (op-size word 0))
  (inst 'mov esi (index esp 4))
  (inst 'add esi ebp)
  (ppmov ecx (- (* 17 2) 2))
  (inst 'lea edi (index esp 8))
  (inst 'rep)
  (inst 'movsd)
  (inst 'mov esi esp)
  (call 'ShowDZone)
  (call 'ShowDZone))

(add-code! 
 'codeseg
 (seq (label 'PM_Entry_Point)
; Initialize Registers for protected mode
;Input:
; we just entered protected mode;
; the pmpart is in its original place at segment 0
; [XtdMem] contains the amount of available extended memory, at least 128KB.
;Output:
; cs,ds,es,fs,ss now allow addressing of the whole linear (physical) memory
; ebp points to the target address for the top of the PM part
; esp points to the target address for __Stack_Top__
; some variables are initialized: [Id_Pgtbl_Num]
; eflags is cleared (particularly no interrupts & string instructions upward)
; except for IOPL which is set to 3.
; other gregisters are still uninitialized
      ; Initialize ds,es,fs
      (ppmov ds ALLMEMDS)
      (ppmov es ds)
      (ppmov fs ds)
      (STOP ds #xB8000 78 00 (char->integer #\P) 0x49)
      (STOP es #xB8000 79 00 (char->integer #\M) 0x49)

      ; compute the target location for PM Part.
	; (?) should we limit it to 16 MB, as linux allows to do ???
	; well, in that case, it'd be better to change the LOADER, I guess.
	; people would also add a handler for extra memory as buffer...
      ; EBP is top of memory
      (inst 'mov ebp (index (name 'XtdMem)))
      (inst 'add ebp #x100000) ; Xtdmem is above 1 MB...
      ; EAX number of 4MB page tables needed to map the memory
      (inst 'mov eax ebp)
      (inst 'dec eax)
      (inst 'sar eax 22)
      (inst 'inc eax)
      (inst 'mov (index (label 'Id_Pgtbl_Num)) eax)
      (inst 'shl eax 12)
      ;mov [Id_Pgtbl_Sz],eax
      ; for further paging, we must be 4KB aligned...
      (inst 'and ebp PAGEMASK)
      ; Possibly limit us to 16 MB
      (if limit-to-16MB
	  (if-then ebp > #x1000000 (mov ebp #x1000000)))
      ; let enough space for identity mapping page tables
      (inst 'sub ebp eax)

      ; Initialize SS:
      ; same all memory segment, stack physically where it belongs.
      (ppmov ss ds)
      (inst 'lea esp (index ebp (pmaddr (name '__Stack_Top__))))

      ;NB: I lost a lot of time finding a bug:
      ;  ***addressing using ebp implicitly uses ss***,
      ;  but I had ss still in the rmpart segment,
      ;  so anytime I tried to use ebp-addressing
      ;  meaning ds not ss, it just crashed (GPF) 8-( )-8


      ; Initialize EFLAGS.
      ; Particularly, clear interrupts, allow user to do IO,
      ; Initialize convention of direction flag being clear (moving upward),
      ; Clear some nasty flags that real-mode may have given us: NT, AC, etc.
      (ppmov 'fd FLAG_IOPL3)

      ; Print "Welcome to "
      ;Input:
      ; we have a color adaptor in text mode with buffer at 0xB8000
      ;Ouput:
      ; message printed
      ; ebp not modified
      (mov edi #0xB8000+2*(00+0*80))
      (mov eax #x07650757)	; 'We'
      (inst 'stosd)
      (mov eax #x0763076C)	; 'lc'
      (inst 'stosd)
      (mov eax #x076D076F)	; 'om'
      (inst 'stosd)
      (mov eax #x07200765)	; 'e '
      (inst 'stosd)
      (mov eax #x076F0774)	; 'to'
      (inst 'stosd)


      ; Move the Protected-Mode Part to where it belongs: up extended memory.
      ;Input:
      ; ebp contains target address for the PM part.
      ;Output:
      ; ebp unchanged
      ; the PM part is moved, and the bss is cleared.
      ; Do Move
      (mov esi (name 'pmpart_actbeg))
      (inst 'lea edi (index ebp (pmaddr (name 'pmpart_actbeg))))
      (mov ecx (binop "/" (binop "+" (name 'pmpart_actlen) 3) 4))
      (inst 'rep)
      (inst 'movsd)

      ; Clear the zone containing uninitialized PM part data
      ; So we can be confident that data defined up there is properly zeroed
      ; Could someone tell me what "bss" stands for ???
      (clr eax)
      (inst 'mov ecx (binop "/" (binop "+" (name 'pmpart_bsslen) 3) 4))
      (inst 'rep)
      (inst 'stosd)


      ; Initialize the GDT
      ;Input:
      ; ebp contains the physical address of the PM part.
      ;Output:
      ; The PMPART and RMPART entries of the GDT are initialized.
      ; The [PM_GDT_address] variable in RM part is initialized
      ; The GDT register is loaded.
      ; ebp unchanged
      ; ebx contains the physical address of the RMPART
      ;Note:
      ;   Lookout: KL0 entries are still at their ALLMEM values;
      ; but this shouldn't matter if we call Init_Paging before to use them
      ; (in particular, before any interrupt occurs).

      ; Copy the original GDT
      ; No more necessary since the original is now the final one, too !
      ;mov esi,#Orig_GDT
      ;lea edi,[ebp+pmaddr(__GDT__)]
      ;mov ecx,#Orig_GDT_Len/4
      ;rep
      ;movsd

      ; Modify the PMPART entries to point up in physical memory
      (inst 'mov ax #xC09A)
      (inst 'mov ebx ebp)
      (inst 'mov ecx #xFFFFF)
      (inst 'lea edx (index ebp (pmaddr (label '__GDT__)) PMPARTCS))
      (call 'SetDescriptor)
      (inst 'add edx (- PMPARTDS PMPARTCS))
      (inst 'mov al #x92)
      (call 'SetDescriptor)

      ; Modify the RMPART entries
      (inst 'mov ebx (index (label 'RM_Part_seg)))
      (inst 'shl ebx 4)
      (inst 'mov ah #x10)
      (inst 'shr ecx 4)
      (inst 'add edx (- RMPARTDS PMPARTDS))
      (call 'SetDescriptor)
      (inst 'mov al #x9A)
      (inst 'add edx (- RMPARTCS RMPARTDS))
      (call 'SetDescriptor)

      ; Set the GDT variable in RM part, so further RM->PM switching works
      (inst 'lea eax (index edx (- RMPARTCS)))
      (inst 'mov (index ebx (rmaddr (label 'PM_GDT_base))) eax)
      (inst 'mov (op-size word (index ebx (rmaddr (label 'PM_GDT_lim))))
	    (- GDT_SIZE 1))

      ; Re-load the GDT
      (inst 'lgdt (index ebx (rmaddr (label 'PM_GDT_address))))



      ; Re-Initialize registers
      ;Input:
      ; cs,ds,es,ss,fs point to ALLMEM
      ; ebp contains the physical address of the PM part
      ; ebx contains the physical address of the RM part
      ;Output:
      ; We now execute code at its definitive address
      ; cs,ds,es,ss,gs point to the PMPART (*not* KL0)
      ; esp is adjusted stack is at the same physical place as before.
      ; ebp is unchanged
      ; eax points to the logical address of physical memory in PMPART
      ; fs still points to ALLMEM
      ; Some variables are initialized or adjusted:
      ; [PM_Part_Phys], [RM_Part_Phys], [PM_IDT_addr] (GDT done earlier)
      ; [RM_Part_Addr], [PhysicalMem], [Video_mem_base]
      ; [V86_REQUEST_Adjust-4]
      ; [PM_Target_ofs]
      ; [X86_FLAGS_Addr], [GDT_Addr_Addr]

      ; Adjust cs:eip
      (STOP ds #xB8000 78 01 (char->integer #\U) 0x78)
      (inst 'jmpi (pmaddr (label 'UpTherePM)) PMPARTCS)
      (label 'UpTherePM)
      (STOP ds #xB8000 79 01 (char->integer #\P) #x78)

      ; Ajust ds,es,gs
      (ppmov ds PMPARTDS)
      (ppmov es ds)
      (ppmov gs ds)
      
      ; Adjust ss,esp
      (ppmov ss ds)
      (inst 'sub esp ebp)

      ; Initialize RM-related variables
      (inst 'mov eax ebx)
      (inst 'mov (index (pmaddr (name 'RM_Part_Phys))) eax)
      (inst 'add (index (pmaddr (binop "-" (label 'V86_REQUEST_Adjust) 4)))
	    eax)
      (inst 'sub eax ebp)
      (inst 'mov (index (pmaddr (name 'RM_Part_Addr))) eax)
      (inst 'add (index (pmaddr (label 'X86_FLAGS_Addr))) eax)
      (inst 'add (index (pmaddr (label 'GDT_Addr_Addr))) eax)
      (inst 'mov (index eax (rmaddr (label 'PM_Target_ofs)))
	    (pmaddr (label 'Return_From_R86)))
      
      ; Initialize PM-related variables
      (inst 'mov eax ebp)
      (inst 'mov (index (pmaddr (name 'PM_Part_Phys))) eax)
      (inst 'add (index (pmaddr (label 'PM_IDT_base))) eax)
      (inst 'neg eax)
      (inst 'mov (index (pmaddr (name 'PhysicalMem))) eax)
      (inst 'add (index (pmaddr (label 'Video_mem_base))) eax)


      ; Proudly, hackishly, print " Tunes !", and clear rest of screen
      ;Input:
      ; eax points to the physical memory in PMPART
      ;Output:
      ; eax-20 now points to video frame buffer in PMPART
      ; ebp unchanged
      ; hack score incremented ";-)"
      ; We're assuming no interrupts, color screen at B800, etc.
      (inst 'xchg eax esp)
      (inst 'add esp (+ #xB8000 (* 2 25 80)))
      (inst 'mov ecx (quotient (- (* 80 25) 18) 2))
      (Loopno0 (inst 'push #x07200720))
      (pushm #x0F540F20 #x0F6E0F75 #x0F730F65 #x07210720)
      (inst 'xchg eax esp)

	
      ; Setup Paging
      ;Output:
      ; Paging enabled, with segments now KL0 executing up in linear memory.
      ; Wow !
      ; gdt and idt registers re-loaded for paging, too
      ; only eax,esi are wasted
      (STOP fs #xB8000 25 0 (char->integer #\P) #x29)
      (DLINE 1)
      (if debug2
	  (seq (movm (list ebp (index (pmaddr (name 'PhysicalMem))))
		     (list eax (index (pmaddr (name 'GDT_Addr_Addr))))
		     (list edx (index (pmaddr (name 'RM_Part_Addr))))
		     (list cx (index eax))
		     (list ebx (index eax 2)))
	       (STOP fs #xB8000 9 0 (char->integer #\X) #x2F)
	       (if debug1 (pr '(eregs)) (seq))
	       (STOP fs #xB8000 9 0 (char->integer #\Y) #x2F)
	       (PrGDT)
	       (STOP fs #xB8000 9 0 (char->integer #\Z) #x2F))
	  (seq))

      (call 'Init_Paging)
      (STOP fs #xB8000 26 0 (char->integer #\G) #x29)
      (STOP es #xB8000 27 0 (char->integer #\E) #x29)
      (STOP ds (binop "-" ebx 20) 28 0 (char->integer #\N) #x29)
      (if debug2
	  (seq (SHOWL "Paging Enabled")
	       (movm (list ebp 0)
		     (list eax (index (pmaddr (name 'GDT_Addr_Addr))))
		     (list edx (index (pmaddr (name 'RM_Part_Addr))))
		     (list cx (index eax))
		     (list ebx (index eax 2)))
	       (STOP fs #xB8000 9 0 (char->integer #\X) #x2F)
	       (if debug1 (pr '(eregs)) (seq))
	       (STOP fs #xB8000 9 0 (char->integer #\Y) #x2F)
	       (PrGDT)
	       (STOP fs #xB8000 9 0 (char->integer #\Z) #x2F))
	  (seq))


      ; Setup Initial Task register and structures
	(DMSG "TR TSSs Switch" 50 24 #x09 fs #xB8000)
	(movzil eax DummyTSS)
	(inst 'ltr ax)
	(LETTER 2)
	(movm (list edi (pmaddr (name 'K_TSS)))
	      (list esi esp)
	      (list al KL0CS)
	      (list ebx (pmaddr (label 'SwitchMe)))
	      (list ecx FLAG_IOPL3)
	      (list (index (pmaddr (binop "+" (name 'K_TSS) 
					  (name 'TSS32 'EAX))))
		    #xDEADBEEF))
	(call 'Init_TSS)
	(LETTER 4)
	;(if debug1 (pr '(eregs)) (seq))
	(LETTER 2)
	(inst 'jmpi 0 KTSS)
	(label 'SwitchMe)
	(LETTER 3)
	;(if debug1 (pr '(eregs)) (seq))
	(LETTER 3)
; With flag NT set, iretd would result in an exception 0xA,
;because Dummy_TSS is invalid. Why it is invalid I don't know.


; Setup Interrupts
;Input:
; idt register previously loaded
;Output:
; IDT zone initialized to manage exceptions reflect IRQs into RM.
; PIC chips reprogrammed.
; ebp,ebx unmodified
	(STOP fs #xB8000 0 24 (char->integer #\I) #x0B)
	; Redirect Hardware Interrupts
	(call 'Setup_PM_8259)
	(STOP fs #xB8000 1 24 (char->integer #\H) #x03)
	; Initialize PM IDT:
	; Move the parts of original IDT: exception handlers
	(inst 'mov esi (pmaddr (label 'Orig_IDT_exc)))
	(inst 'mov edi (pmaddr (name '__IDT__)))
	(inst 'mov ecx (binop "/" (name 'Orig_IDT_exc_Len) 4))
	(inst 'rep)
	(inst 'movsd)
	(STOP fs #xB8000 4 24 (char->integer #\e) #x03)
	; Move the parts of original IDT: interrupt handlers
	(inst 'add edi (binop "-" (* IRQ_INT_BASE 8) (name 'Orig_IDT_exc_Len)))
	(inst 'mov ecx (binop "/" (name 'Orig_IDT_irq_Len) 4))
	(inst 'rep)
	(inst 'movsd)
	(STOP fs #xB8000 5 24 (char->integer #\i) #x03)
	; Do NOT load IDT register: it is done in before according to PM/RM
	;lidt [pmaddr(PM_IDT_address)]	; necessary if not paging.
	;(STOP fs #xB8000 6 24 (char->integer #\l) #x03)

; Setup the PM->RM reflector
;Output:
; ebp conserved
	; Initialize RM IDT:
	(call 'Init_RM_IDT)
	(STOP fs #xB8000 2 24 (char->integer #\R) #x03)
	; Initialize ReflINT V86INT:
	(inst 'mov eax (index (pmaddr (label 'RM_Part_seg))))
	(inst 'mov (index (pmaddr (binop "+" (name 'ReflINT_V86INT) 
					 (name 'V86INT 'SS))))
	      eax)
	(inst 'mov (index (pmaddr (binop "+" (name 'ReflINT_V86INT) 
					 (name 'V86INT 'ESP))))
	      (rmaddr (name 'RMPartStackTop)))
	(inst 'mov (index (pmaddr (binop "+" (name 'ReflINT_V86INT) 
					 (name 'V86INT 'CS))))
	      eax)
	(inst 'mov (index (pmaddr (binop "+" (name 'ReflINT_V86INT)
					 (name 'V86INT 'EIP))))
	      (rmaddr (label 'RM_Idle)))
	;(!) EFLAGS must be zeroed. ok because defined as "uninitialized" data
	(STOP fs #xB8000 3 24 (char->integer #\V) #x03)
	; Initialize the Current RM V86INT
	;done at compile time (see definition for Current_RM_V86INT)


; Setup RM->PM reflector
;Output:
; RM interceptor IDT initialized.
; ebp conserved
	; Initialize RM Interceptor IDT.
	; If in "intercept all RM interrupts" mode,
	; all interrupts point to the same place
	; except that the low byte of cs indicates the interrupt number.
	(inst 'mov ebx (index (pmaddr (label 'RM_Part_Addr))))
	;(inst 'mov eax (index (pmaddr (label 'RM_Part_seg)))) 
                                ; (!) must have been done just before
	(inst 'add eax eax)
	(inst 'lea eax (index (scale eax 8)
			      (rmaddr (label 'INT_Interceptor))
			      (- 0x2000))) ;8*2=16 !!!
	(inst 'mov edx eax)
	(inst 'and edx #x00FFF)
	(inst 'and eax #xFF000)
	(inst 'shl eax 12)
	(inst 'lea eax (index eax edx #x2000))
	(inst 'mov edi (pmaddr (name '__RM_IDT__)))
	(inst 'mov cx 256)
	(Loopno0 (inst 'stosd)
		 (inst 'add eax (- #x10000 #x10)))
	(STOP fs #xB8000 6 24 (char->integer #\R) #x03)


; Ready interrupts
;Output:
; the system is ready to process interrupts, but they are still disabled.
; eax lost
	(call 'Enable_NMI)
	(call 'Unmask_IRQs)
	(call 'Flush_Interrupts)
	(STOP fs #xB8000 70 24 (char->integer #\I) #x0C)




; ***** (!!!) Below this line, code is under heavy development/testing *****

	(DMSG "So now, we're testing at last; don't try to efhzoe me baby."
	      0 22 0x0E fs 0xB8000)
	(LETTER 10)

	(IT_OPT "X86" (die))

	; Initialize Test_V86INT
	(DBG "V")
	(inst 'mov ebx (pmaddr (label 'Test_V86INT)))
	(inst 'mov eax (index (pmaddr (label 'RM_Part_seg))))
	(inst 'mov (index ebx (name 'V86INT 'CS)) eax)
	(inst 'mov (index ebx (name 'V86INT 'DS)) eax)
	(inst 'mov (index ebx (name 'V86INT 'SS)) eax)
	(DBG "86")

	;(inst 'sti)
	; see archive of routines in test.S



; ---------------------------------------------------------------------------
; Now let's go to the LLL
; ---------------------------------------------------------------------------

	; Initialize a stream input to what follows the API in the image file.
	(inst 'mov ebp (index (pmaddr (name 'PM_Part_Phys))))
	(inst 'mov ecx (name 'APISIZE))
	(inst 'mov eax (index ebp (label 'System_Length)))
	(inst 'sub eax ecx)
	(inst 'add ecx ebp)
	(inst 'mov (index (pmaddr (name 'Init_Stream_base))) ecx)
	(inst 'mov (index (pmaddr (name 'Init_Stream_len))) eax)
	;......


	; Here we are (Pphew !)
	; Jump into LLL code
	(STOP fs #xB8000 71 24 (char->integer #\J) #x0C)
	;......
	(STOP fs #xB8000 72 24 (char->integer #\K) #x0C)


	; When TUNES runs, there will be no return
	; ( but TUNES being able to run arbitrary continuations,
	; it will be possible to halt, reboot, or launch another OS ;-)

	; Exit back to real mode
	; Bye bye !

	(STOP fs #xB8000 78 24 (char->integer #\B) #x0C)

	(inst 'cli)
	(call 'Mask_IRQs)
	(call 'Disable_NMI)
	(call 'Setup_RM_8259)
	(call 'Flush_Interrupts)
	(call 'DumpV86INT)
	(inst 'mov ecx 50)
	(call 'sleep)
	(call 'Call_R86)

	; Error ?
	STOP(fs,0xB8000,79,24,'E,0x8F)
	(die) ; This point should never be reached !

	(label 'Test_V86INT)
	(data long 1) (data long 2) (data long 3) (data long 4)
	(data long 5) (data long 6) (data long 7) (data long 8) ; PUSHAD_
	(data long 0)                   ; EIP
	(data long 0)                   ; CS
	(data long #x00003046)		; EFLAGS
	(data long (rmaddr (label 'rmpart_actbeg))) ; ESP
	(data long 0)                   ; SS
	(data long #xB800)              ; ES
	(data long 0)                   ; DS
	(data long 0)                   ; FS
	(data long 0)                   ; GS
	))




; ---------------------------------------------------------------------------
; Initialization Data
; ---------------------------------------------------------------------------

(add-code! 
 'dataseg
 (seq (label 'Orig_IDT_exc)
      (apply seq (map (lambda (exc_handler)
			(defgate KL0CS (pmaddr (label exc_handler)) 0 #x8E))
		      '(Division_Error_Trap
			Single_Step_Trap
			NMI_Trap
			BreakPoint_Trap
			Overflow_Trap
			Out_of_Bound_Trap
			Invalid_Opcode_Trap
			Emulate_Coproc_Trap
			Double_Fault_Stop
			Coproc_Segment_Stop
			Invalid_TSS_Fault
			Segment_Not_Present_Fault
			Stack_Fault
			General_Protection_Fault
			Page_Fault
			Reserved_0F_Fault
			Coprocessor_Error_Fault
			Alignment_Check_Fault)))
      (label 'Orig_IDT_exc_end)
      (def 'Orig_IDT_exc_Len (binop "-" (label 'Orig_IDT_exc_end) 
				    (label 'Orig_IDT_exc)))

;Orig_IDT_serv:
;Orig_IDT_serv_end:
;Orig_IDT_serv_Len = Orig_IDT_serv_end - Orig_IDT_serv

      (label 'Orig_IDT_irq)
      (apply seq (map (lambda (irq)
			(defgate KL0CS (pmaddr (label irq)) 0 #x8E))
		      '(IRQ0_Timer	; 0
			IRQ1_Keyboard	; 1
			IRQ2_Cascade    ; 2
			IRQ3		; 3
			IRQ4		; 4
			IRQ5		; 5
			IRQ6		; 6
			IRQ7		; 7
			IRQ8_RTC	; 8
			IRQ9		; 9
			IRQ10		; A
			IRQ11		; B
			IRQ12		; C
			IRQ13		; D
			IRQ14		; E
			IRQ15)))	; F
      (label 'Orig_IDT_irq_end)
      (def 'Orig_IDT_irq_Len (binop "-" (label 'Orig_IDT_irq_end) 
				    (label 'Orig_IDT_irq)))))


; (!) This takes place at the very end of pmdata segment
(add-code! 
 '(pmdata 2)
 (seq (text ".align 16")
      (label 'Orig_GDT)
      (label '__GDT__)

      (DefDescriptor 0 #x00000 #x00 #x00) ; NULL
      (DefDescriptor 0 #xFFFFF #xF2 #xC0) ; (!) PL3 ALLMEM access   ; TEMPSEG
      (DefDescriptor 0 #xFFFFF #x9A #xC0) ; ALLMEMCS
      (DefDescriptor 0 #xFFFFF #x92 #xC0) ; ALLMEMDS
      (DefDescriptor (binop "-" (label 'rmpart_end) #x10000)
	#xFFFF #x9A #x00)		; RMPARTCS
      (DefDescriptor (binop "-" (label 'rmpart_end) #x10000)
	#xFFFF #x92 #x00)		; RMPARTDS
      (DefDescriptor (label 'pmpart_end) #xFFFFF #x9A #xC0) ; PMPARTCS
      (DefDescriptor (label 'pmpart_end) #xFFFFF #x92 #xC0) ; PMPARTDS
      (DefDescriptor 0 #xFFFFF #x9A #xC0) ; KL0CS
      (DefDescriptor 0 #xFFFFF #x92 #xC0) ; KL0DS
      (DefDescriptor 0 #xFFFFF #xBA #xC0) ; KL1CS
      (DefDescriptor 0 #xFFFFF #xB2 #xC0) ; KL1DS
      (DefDescriptor 0 #xFFFFF #xDA #xC0) ; KL2CS
      (DefDescriptor 0 #xFFFFF #xD2 #xC0) ; KL2DS
      (DefDescriptor 0 #xFFFFF #xFA #xC0) ; (!!) normal limit #xBFFFF	; KL3CS
      (DefDescriptor 0 #xFFFFF #xF2 #xC0) ; (!!) normal limit #xBFFFF	; KL3DS
      (DefGate KL0CS (pmaddr (label 'KL0_CallGate)) 0 #x8C) ; ?		; KL0CG
      (DefGate KL0CS (pmaddr (label 'KL1_CallGate)) 0 #xAC) ; KL1CG
      (DefGate KL0CS (pmaddr (label 'KL2_CallGate)) 0 #xCC) ; ?		; KL2CG
      (DefGate KL0CS (pmaddr (label 'KL3_CallGate)) SysCallArgC #xEC) ; KL3CG
      (DefDescriptor (pmaddr (name 'K_TSS))     #xFFFF #x89 #x00) ; KTSS
      (DefDescriptor (pmaddr (name 'Dummy_TSS)) #xFFFF #x89 #x00) ; DummyTSS
      (DefDescriptor (pmaddr (name 'V86_TSS))   #xFFFF #x89 #x00) ; V86TSS
      (DefDescriptor (pmaddr (name 'User_TSS))  #xFFFF #x89 #x00) ; UserTSS

      (label 'Orig_GDT_end)
      (def 'Orig_GDT_Len (binop "-" (label 'Orig_GDT_end) (label 'Orig_GDT)))
      ; (!!!) Must be the same as Orig_GDT_SIZE
      (def 'zzz_CheckMeZero (binop "-" (name 'Orig_GDT_Len) Orig_GDT_SIZE))))


; ---------------------------------------------------------------------------
; Test code for R/P mode switching
; ---------------------------------------------------------------------------

(set! p-mode #f)

; Test code for R86/V86 reflectors...
(add-code! 
 'codeseg
 (seq (label 'Test_V86)
      (label 'V86_Test)
      (inst 'cli)
      (STOP es 0 40 0 (char->integer #\V) #xA)
      (inst 'mov (index (rmaddr (label 'RM_DumpLine))) #2)
      (if debug1 (pr '(eregs)) (seq))
      (STOP es 0 41 0 (char->integer #\V) #xA)
      ;(inst 'mov ecx 100000000)
      ;(label 'BBBB)
      ;(inst 'dec ecx)
      ;(inst 'jnz BBBB)

      ;(inst 'mov ax (index #x100000))
      ;(inst 'cli)

      (STOP es 0 42 0 (char->integer #\V) #xA)
      (pr "Hello, V86 World !\r\n")
      ;CGETC
      (STOP es 0 43 0 (char->integer #\T) #xA)
      (inst 'push cs)
      (call 'X86_RETURN)

      (label 'R86_Test)
      (STOP es 0 40 24 (char->integer #\R) #xA)
      ;(pushing (list es)
      ;         (inst 'mov ax #x0003) ; clear screen
      ;         (inst 'int #x10))
      ;(inst 'cli)
      (inst 'mov (index (rmaddr (label 'RM_DumpLine))) #15)
      (if debug1 (pr '(eregs)) (seq))
      (pr "Hello, R86 World !\r\n")
      (wait-for-char)
      (STOP es 0 41 23 (char->integer #\T) #xA)
      (if debug1 (pr '(eregs)) (seq))
      (STOP fs #xB8000 42 23 (char->integer #\M) #xA)
      (inst 'push cs)
      (call 'X86_RETURN)

      (label 'RM_Return_Point)
      ; Nothing to restore: every was restored by the R86 handler !
      ; Show that we got there
      (STOP fs #xB8000 0 9 (char->integer #\R) #xE)
      (STOP es 0 75 24 (char->integer #\R) #xC)		; 'R' for RealMode
      (STOP es 0 76 24 (char->integer #\e) #xC)		; 'e' for RealMode
      ; Try accessing ALLMEMDS through fs.
      (STOP fs #xB8000 77 24 (char->integer #\A) #xC)	; 'A' for Allmem
      (STOP fs #xB8000 78 24 (char->integer #\l) #xC)	; 'l' for Allmem
      (STOP fs #xB8000 79 24 (char->integer #\l) #xC)	; 'l' for Allmem

      (inst 'mov ax #x0003)
      (inst 'int #x10)

      ; Print some stuff

      (inst 'seg fs)
      (inst 'mov eax (index (* IRQ_INT_BASE 4)))
      (inst 'seg fs)
      (inst 'mov ebx (index (+ (* IRQ_INT_BASE 4) (* 8 4))))

      (if debug1 (pr '(eregs)) (seq))
      (STOP fs #xB8000 71 9 (char->integer #\a) #xB)	; another 'a'



      ; Restore Interrupt Controller
      (STOP es 0 58 9 (char->integer #\R) #x61)
      ;call RM_Setup_RM_8259
      (STOP es 0 59 9 (char->integer #\8) #x61)
      ;call RM_Flush_Interrupts
      (STOP es 0 70 9 (char->integer #\B) #xB)		; 'B' for Back

      ; Reenable Interruptions
      (call 'RM_Unmask_IRQs)
      (call 'RM_Enable_NMI)
      (ppmov ds cs)
      (STOP es 0 71 9 (char->integer #\a) #xB)		; 'A' for Back

      (if debug1 (pr "Back in real mode:\r\n") (seq))
      (STOP es 0 72 9 (char->integer #\c) #xB)		; 'c' for Back
      (if debug1 (pr '(regs)) (seq))

      ; That's all, folks
      (STOP es 0 73 9 (char->integer #\k) #xB)		; 'k' for Back
      (pr "\r\nHit any key to reboot.")
      (wait-for-char)
      (STOP es 0 74 8 (char->integer #\!) #xB)		; '!' for Back!
      ; Reboot !
      (inst 'mov ax #x1234)
      (ppmov es 0)
      (inst 'seg es)
      (inst 'mov (index #x472) #x1234)
      (inst 'seg es)
      (inst 'mov (index #x467) #x1234)
      (inst 'mov al #xFE)	; Pulse "reset" = 8042 pin 0
      (inst 'out #x64 al)
      (die)	; It takes some time to reboot, so let's wait a bit.
      ))
